/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.karaf.adb;

import de.mhus.lib.core.MCast;
import de.mhus.lib.core.util.Rfc1738;
import de.mhus.lib.karaf.adb.DbManagerService;
import de.mhus.lib.karaf.adb.DbManagerServiceProvider;
import java.io.IOException;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class AdbUtil {
    public static Class<?> getType(DbManagerService service, String typeName) throws IOException {
        for (Class item : service.getManager().getSchema().getObjectTypes()) {
            if (!item.getSimpleName().equals(typeName)) continue;
            return item;
        }
        throw new IOException("Type not found in service: " + typeName);
    }

    public static List<DbManagerServiceProvider> getServiceProviders(BundleContext context) {
        LinkedList<DbManagerServiceProvider> out = new LinkedList<DbManagerServiceProvider>();
        try {
            for (ServiceReference sr : context.getServiceReferences(DbManagerServiceProvider.class, null)) {
                DbManagerServiceProvider service = (DbManagerServiceProvider)context.getService(sr);
                out.add(service);
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
        return out;
    }

    public static List<DbManagerService> getServices(BundleContext context, boolean connectedOnly) {
        LinkedList<DbManagerService> out = new LinkedList<DbManagerService>();
        for (DbManagerServiceProvider provider : AdbUtil.getServiceProviders(context)) {
            for (DbManagerService service : provider.getServices()) {
                if (connectedOnly && !service.isConnected()) continue;
                out.add(service);
            }
        }
        return out;
    }

    public static DbManagerService getService(BundleContext context, String serviceName) throws IOException, InvalidSyntaxException {
        for (DbManagerServiceProvider provider : AdbUtil.getServiceProviders(context)) {
            for (DbManagerService service : provider.getServices()) {
                if (!serviceName.equals(service.getServiceName())) continue;
                return service;
            }
        }
        throw new IOException("Servie not found: " + serviceName);
    }

    public static Object createAttribute(Class<?> type, Object value) {
        if (value == null || value.equals("[null]")) {
            return null;
        }
        if (value.equals("[uuid]")) {
            return UUID.randomUUID();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.startsWith("[") && str.endsWith("]")) {
                String[] parts = str.substring(1, str.length() - 1).split(",");
                for (int i = 0; i < parts.length; ++i) {
                    parts[i] = Rfc1738.decode((String)parts[i]);
                }
                value = parts;
            } else {
                value = Rfc1738.decode((String)str);
            }
        }
        if (type == value.getClass()) {
            return value;
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return MCast.toint((Object)value, (int)0);
        }
        if (type == Long.TYPE || type == Long.class) {
            return MCast.tolong((Object)value, (long)0L);
        }
        if (type == Float.TYPE || type == Float.class) {
            return Float.valueOf(MCast.tofloat((Object)value, (float)0.0f));
        }
        if (type == Double.TYPE || type == Double.class) {
            return MCast.todouble((Object)value, (double)0.0);
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return MCast.toboolean((Object)value, (boolean)false);
        }
        if (type == Date.class) {
            return MCast.toDate((String)String.valueOf(value), null);
        }
        if (type == UUID.class) {
            return UUID.fromString(String.valueOf(value));
        }
        if (type.isEnum()) {
            return String.valueOf(value);
        }
        return null;
    }
}

