package de.mhus.lib.karaf.adb;

import java.util.HashMap;
import java.util.List;

import org.apache.felix.service.command.CommandSession;
import org.apache.karaf.shell.commands.Action;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.osgi.framework.BundleContext;

import de.mhus.lib.adb.DbCollection;
import de.mhus.lib.adb.model.Field;
import de.mhus.lib.adb.model.Table;
import de.mhus.lib.core.MString;
import de.mhus.lib.core.console.ConsoleTable;

@Command(scope = "adb", name = "select", description = "Select data from ADB DataSource ant print the results")
public class CmdSelect implements Action {

	private BundleContext context;
	
	@Argument(index=0, name="service", required=true, description="Service Class", multiValued=false)
    String serviceName;

	@Argument(index=1, name="type", required=true, description="Type to select", multiValued=false)
    String typeName;
	
	@Argument(index=2, name="qualification", required=false, description="Select qualification", multiValued=false)
    String qualification;

	@Argument(index=3, name="attributes", required=false, description="Attributes for the select, e.g user=alfons", multiValued=true)
    String[] attributes;
	
	public void setContext(BundleContext context) {
        this.context = context;
    }

	@Override
	public Object execute(CommandSession session) throws Exception {
		
		DbManagerService service = AdbUtil.getService(context,serviceName);
		Class<?> type = AdbUtil.getType(service, typeName);
		
		HashMap<String, Object> attrObj = null;
		if (attributes != null) {
			attrObj = new HashMap<>();
			for (String item : attributes) {
				String key = MString.beforeIndex(item, '=').trim();
				String value = MString.afterIndex(item, '=').trim();
				attrObj.put(key, value);
			}
		}
		
		
		String regName = service.getManager().getRegistryName(type);
		Table tableInfo = service.getManager().getTable(regName);
		
		ConsoleTable out = new ConsoleTable();
		for (Field f : tableInfo.getFields())
			out.getHeader().add(f.getName());
		
		DbCollection<?> res = service.getManager().getByQualification(type, qualification, attrObj);
		
		for (Object item : res) {
			List<String> row = out.addRow();
			for (Field f : tableInfo.getFields())
				row.add( String.valueOf(f.get(item)));
		}
		res.close();
		
		out.print(System.out);
		
		return null;
	}
	

}
