/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.karaf.adb;

import de.mhus.lib.adb.DbManager;
import de.mhus.lib.adb.DbSchema;
import de.mhus.lib.core.MActivator;
import de.mhus.lib.core.MException;
import de.mhus.lib.core.MSystem;
import de.mhus.lib.core.activator.ActivatorImpl;
import de.mhus.lib.core.directory.DirectoryNode;
import de.mhus.lib.core.logging.Log;
import de.mhus.lib.core.logging.MLogger;
import de.mhus.lib.karaf.DataSourceUtil;
import de.mhus.lib.karaf.adb.DbManagerService;
import de.mhus.lib.sql.DataSourceProvider;
import de.mhus.lib.sql.DbPool;
import de.mhus.lib.sql.DbProvider;
import de.mhus.lib.sql.DefaultDbPool;
import de.mhus.lib.sql.Dialect;
import javax.sql.DataSource;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;

public abstract class DbManagerServiceImpl
implements DbManagerService {
    protected BundleContext context;
    protected DataSourceUtil util;
    private String dataSourceName;
    private DbManager manager;
    protected Log log = MLogger.getLog(this.getClass());

    public void doActivate(ComponentContext ctx) {
        this.log.i(new Object[]{"Activate"});
        this.context = ctx.getBundleContext();
        try {
            this.doOpen();
        }
        catch (Exception e) {
            this.log.e(new Object[]{e});
        }
    }

    public void doDeactivate(ComponentContext ctx) {
        this.log.i(new Object[]{"Deactivate"});
        this.doClose();
    }

    protected abstract void doInitialize() throws Exception;

    protected void doOpen() throws Exception {
        if (this.manager != null) {
            return;
        }
        this.doInitialize();
        this.util = new DataSourceUtil(this.context);
        if (this.getDataSource() == null) {
            return;
        }
        this.manager = this.doCreateDbManager();
    }

    protected void doClose() {
        if (this.manager == null) {
            return;
        }
        this.manager.getPool().close();
        this.manager = null;
    }

    protected DbManager doCreateDbManager() throws Exception {
        DbPool pool = this.doCreateDataPool();
        DbSchema schema = this.doCreateSchema();
        return new DbManager(pool, schema);
    }

    protected abstract DbSchema doCreateSchema();

    protected DbPool doCreateDataPool() {
        return new DefaultDbPool((DbProvider)new DataSourceProvider(this.getDataSource(), this.doCreateDialect(), this.doCreateConfig(), this.doCreateActivator()));
    }

    protected MActivator doCreateActivator() {
        try {
            return new ActivatorImpl(null, this.getClass().getClassLoader());
        }
        catch (MException e) {
            this.log.e(new Object[]{e});
            return null;
        }
    }

    protected DirectoryNode doCreateConfig() {
        return null;
    }

    protected Dialect doCreateDialect() {
        return null;
    }

    protected DataSource getDataSource() {
        DataSource ds = this.util.getDataSource(this.dataSourceName);
        if (ds == null) {
            this.log.w(new Object[]{"DataSource is unknown", this.dataSourceName});
        }
        return ds;
    }

    @Override
    public void updateDataSource() throws Exception {
        if (!this.isConnected()) {
            if (this.getDataSource() == null) {
                return;
            }
            this.doOpen();
            return;
        }
        ((DataSourceProvider)this.manager.getPool().getProvider()).setDataSource(this.getDataSource());
    }

    @Override
    public DbManager getManager() {
        return this.manager;
    }

    @Override
    public boolean isConnected() {
        return this.manager != null;
    }

    @Override
    public String getDataSourceName() {
        return this.dataSourceName;
    }

    @Override
    public void setDataSourceName(String dataSourceName) {
        if (MSystem.equals((Object)this.dataSourceName, (Object)dataSourceName)) {
            return;
        }
        this.dataSourceName = dataSourceName;
        try {
            this.updateDataSource();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

