/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.karaf.adb;

import de.mhus.lib.karaf.adb.DbManagerService;
import org.apache.felix.service.command.CommandSession;
import org.apache.karaf.shell.commands.Action;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

@Command(scope="adb", name="update", description="Update ADB DataSource")
public class CmdUpdate
implements Action {
    private BundleContext context;
    @Argument(index=0, name="source", required=true, description="Service Class", multiValued=false)
    String serviceName;
    @Argument(index=1, name="source", required=false, description="Data Source", multiValued=false)
    String sourceName;

    public void setContext(BundleContext context) {
        this.context = context;
    }

    public Object execute(CommandSession session) throws Exception {
        int cnt = 0;
        for (ServiceReference sr : this.context.getServiceReferences(DbManagerService.class, null)) {
            DbManagerService service = (DbManagerService)this.context.getService(sr);
            if (!service.getClass().getCanonicalName().equals(this.serviceName)) continue;
            if (this.sourceName == null) {
                service.updateDataSource();
            } else {
                service.setDataSourceName(this.sourceName);
            }
            ++cnt;
        }
        System.out.println("Updated: " + cnt);
        return null;
    }
}

