/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.karaf.adb;

import de.mhus.lib.adb.DbManager;
import de.mhus.lib.core.console.ConsoleTable;
import de.mhus.lib.karaf.adb.DbManagerService;
import org.apache.felix.service.command.CommandSession;
import org.apache.karaf.shell.commands.Action;
import org.apache.karaf.shell.commands.Command;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

@Command(scope="adb", name="list", description="List all ADB Services")
public class CmdList
implements Action {
    private BundleContext context;

    public void setContext(BundleContext context) {
        this.context = context;
    }

    public Object execute(CommandSession session) throws Exception {
        ConsoleTable table = new ConsoleTable();
        table.setHeaderValues(new String[]{"Service", "Schema", "Bundle", "DataSource", "Managed Types"});
        for (ServiceReference sr : this.context.getServiceReferences(DbManagerService.class, null)) {
            DbManagerService service = (DbManagerService)this.context.getService(sr);
            if (service.isConnected()) {
                DbManager manager = service.getManager();
                StringBuffer types = new StringBuffer();
                for (Class type : manager.getSchema().getObjectTypes()) {
                    if (types.length() != 0) {
                        types.append(',');
                    }
                    types.append(type.getSimpleName());
                }
                table.addRowValues(new String[]{service.getClass().getCanonicalName(), manager.getSchema().getClass().getSimpleName(), sr.getBundle().getSymbolicName(), service.getDataSourceName(), types.toString()});
                continue;
            }
            table.addRowValues(new String[]{service.getClass().getCanonicalName(), "[not connected]", sr.getBundle().getSymbolicName(), service.getDataSourceName(), ""});
        }
        table.print(System.out);
        return null;
    }
}

