package de.mhus.lib.karaf.adb;

import org.apache.felix.service.command.CommandSession;
import org.apache.karaf.shell.commands.Action;
import org.apache.karaf.shell.commands.Command;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

import de.mhus.lib.adb.DbManager;
import de.mhus.lib.core.console.ConsoleTable;

@Command(scope = "adb", name = "list", description = "List all ADB Services")
public class CmdList implements Action {

	private BundleContext context;
	
	public void setContext(BundleContext context) {
        this.context = context;
    }

	@Override
	public Object execute(CommandSession session) throws Exception {
		ConsoleTable table = new ConsoleTable();
		table.setHeaderValues("Service","Schema","Bundle","DataSource","Managed Types");
		// iterate all services
		for ( ServiceReference<DbManagerService> sr : context.getServiceReferences(DbManagerService.class, null)) {
			DbManagerService service = context.getService(sr);
			if (service.isConnected()) {
				DbManager manager = service.getManager();
				StringBuffer types = new StringBuffer();
				for (Class<?> type : manager.getSchema().getObjectTypes()) {
					if (types.length() != 0) types.append(',');
					types.append(type.getSimpleName());
				}
				table.addRowValues(service.getClass().getCanonicalName(),manager.getSchema().getClass().getSimpleName(),sr.getBundle().getSymbolicName(),service.getDataSourceName(),types.toString());
			} else {
				table.addRowValues(service.getClass().getCanonicalName(),"[not connected]", sr.getBundle().getSymbolicName(),service.getDataSourceName(), "");
			}
		}
		table.print(System.out);
		return null;
	}

}
