/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.karaf.impl;

import de.mhus.lib.karaf.db.DelegatedDataSource;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.LinkedList;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class DataSourceFailOver
implements DataSource,
DelegatedDataSource {
    private LinkedList<DataSource> list;

    public DataSource getCurrentDataSource() {
        if (this.list.isEmpty()) {
            return null;
        }
        return this.list.get(0);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.getCurrentDataSource().getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.getCurrentDataSource().setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.getCurrentDataSource().setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.getCurrentDataSource().getLoginTimeout();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.getCurrentDataSource().getParentLogger();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.getCurrentDataSource().unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.getCurrentDataSource().isWrapperFor(iface);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getCurrentDataSource().getConnection();
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        SQLException lastException = null;
        for (int i = 0; i < this.list.size(); ++i) {
            try {
                return this.getCurrentDataSource().getConnection(username, password);
            }
            catch (SQLException e) {
                if (this.list.isEmpty()) {
                    throw e;
                }
                DataSource ds = this.list.removeFirst();
                this.list.addLast(ds);
                lastException = e;
                continue;
            }
        }
        if (lastException != null) {
            throw lastException;
        }
        throw new SQLException("no DataSource found");
    }

    public void setDestinations(LinkedList<DataSource> list) {
        this.list = list;
    }

    @Override
    public String getDelegateURL() {
        try {
            return "failover:" + this.getCurrentDataSource().getConnection().getMetaData().getURL();
        }
        catch (Throwable e) {
            return "failover:" + e;
        }
    }
}

