/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.karaf.impl;

import de.mhus.lib.karaf.DataSourceUtil;
import de.mhus.lib.karaf.db.PoolDataSource;
import de.mhus.lib.karaf.impl.TemplateUtils;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import org.apache.felix.service.command.CommandSession;
import org.apache.karaf.shell.commands.Action;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.osgi.framework.BundleContext;

@Command(scope="jdbc", name="createdbpool", description="Create DB Pool")
public class CmdCreateDbPool
implements Action {
    @Option(name="-o", aliases={"--online"}, description="Create the datasource online and not a blueprint", required=false, multiValued=false)
    boolean online;
    @Argument(index=0, name="source", required=true, description="Source Datasource", multiValued=false)
    String source;
    @Argument(index=1, name="target", required=true, description="New Pooling Datasource", multiValued=false)
    String target;
    private BundleContext context;
    private DataSourceUtil util;

    public Object execute(CommandSession session) throws Exception {
        if (this.online) {
            PoolDataSource dataSource = new PoolDataSource();
            dataSource.setSource(this.source);
            dataSource.setContext(this.context);
            this.util.registerDataSource(dataSource, this.target);
        } else {
            File karafBase = new File(System.getProperty("karaf.base"));
            File deployFolder = new File(karafBase, "deploy");
            File outFile = new File(deployFolder, "datasource-pool_" + this.target + ".xml");
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("name", this.target);
            properties.put("source", this.source);
            String templateFile = "datasource-pool.xml";
            InputStream is = this.getClass().getResourceAsStream(templateFile);
            if (is == null) {
                throw new IllegalArgumentException("Template resource " + templateFile + " doesn't exist");
            }
            TemplateUtils.createFromTemplate(outFile, is, properties);
        }
        return null;
    }

    public void setContext(BundleContext context) {
        this.context = context;
        this.util = new DataSourceUtil(context);
    }
}

