/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.karaf.impl;

import de.mhus.lib.core.console.ConsoleTable;
import org.apache.felix.service.command.CommandSession;
import org.apache.karaf.shell.commands.Action;
import org.apache.karaf.shell.commands.Command;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

@Command(scope="bundle", name="rawlist", description="Return the raw list of bundle names")
public class CmdBundleList
implements Action {
    private BundleContext context;

    public Object execute(CommandSession session) throws Exception {
        ConsoleTable table = new ConsoleTable();
        table.getHeader().add("id");
        table.getHeader().add("Bundle");
        table.getHeader().add("Version");
        table.getHeader().add("State");
        for (Bundle b : this.context.getBundles()) {
            table.addRowValues(new String[]{"" + b.getBundleId(), b.getSymbolicName(), b.getVersion().toString(), this.toState(b.getState())});
        }
        table.print(System.out);
        return null;
    }

    private String toState(int state) {
        switch (state) {
            case 32: {
                return "Active";
            }
            case 2: {
                return "Installed";
            }
            case 4: {
                return "Resolved";
            }
            case 8: {
                return "Starting";
            }
            case 16: {
                return "Stopping";
            }
            case 1: {
                return "Uninsitalled";
            }
        }
        return "" + state;
    }

    public void setContext(BundleContext context) {
        this.context = context;
    }
}

