/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.karaf.impl;

import de.mhus.lib.karaf.db.DelegatedDataSource;
import de.mhus.lib.karaf.impl.DelegateConnection;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;

public abstract class AbstractDataSource
implements DataSource,
DelegatedDataSource {
    protected String instanceName = "";

    public abstract DataSource getDataSource() throws SQLFeatureNotSupportedException;

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.getDataSource().getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.getDataSource().setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.getDataSource().setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.getDataSource().getLoginTimeout();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.getDataSource().getParentLogger();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.getDataSource().unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.getDataSource().isWrapperFor(iface);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return new DelegateConnection(this.getDataSource().getConnection(), this);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        try {
            return this.getDataSource().getConnection();
        }
        catch (SQLException e) {
            this.doDisconnect();
            throw e;
        }
    }

    public abstract void doDisconnect();

    public String getInstanceName() {
        return this.instanceName;
    }

    public abstract boolean isInstanceConnected();

    @Override
    public String getDelegateURL() {
        return this.getInstanceName() + (!this.isInstanceConnected() ? " (disconnected)" : "");
    }
}

