/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.karaf.db;

import de.mhus.lib.karaf.DataSourceUtil;
import de.mhus.lib.karaf.impl.AbstractDataSource;
import java.sql.SQLFeatureNotSupportedException;
import javax.sql.DataSource;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DataSourceConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.osgi.framework.BundleContext;

public class PoolDataSource
extends AbstractDataSource {
    private String source;
    private BundleContext context;
    private DataSource dataSource;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSource getDataSource() throws SQLFeatureNotSupportedException {
        PoolDataSource poolDataSource = this;
        synchronized (poolDataSource) {
            if (this.dataSource == null) {
                DataSource ds = new DataSourceUtil(this.context).getDataSource(this.source);
                GenericObjectPool connectionPool = new GenericObjectPool(null);
                DataSourceConnectionFactory connectionFactory = new DataSourceConnectionFactory(ds);
                PoolableConnectionFactory poolableConnectionFactory = new PoolableConnectionFactory((ConnectionFactory)connectionFactory, (ObjectPool)connectionPool, null, null, false, true);
                this.dataSource = new PoolingDataSource((ObjectPool)connectionPool);
            }
        }
        return this.dataSource;
    }

    @Override
    public void doDisconnect() {
        this.dataSource = null;
    }

    @Override
    public boolean isInstanceConnected() {
        return this.dataSource != null;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
        this.instanceName = "pool:" + source;
    }

    public BundleContext getContext() {
        return this.context;
    }

    public void setContext(BundleContext context) {
        this.context = context;
    }
}

