/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.karaf.db;

import de.mhus.lib.karaf.DataSourceUtil;
import de.mhus.lib.karaf.impl.AbstractDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.LinkedList;
import javax.sql.DataSource;
import org.osgi.framework.BundleContext;

public class FailoverDataSource
extends AbstractDataSource {
    private String source;
    private String realList = "";
    private BundleContext context;
    private LinkedList<DataSource> list;
    private int current = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSource getDataSource() throws SQLFeatureNotSupportedException {
        FailoverDataSource failoverDataSource = this;
        synchronized (failoverDataSource) {
            if (this.list == null) {
                this.current = 0;
                this.list = new LinkedList();
                this.realList = "";
                for (String name : this.source.split(",")) {
                    DataSource dataSource = new DataSourceUtil(this.context).getDataSource(name);
                    if (dataSource == null) continue;
                    this.list.add(dataSource);
                    if (this.realList.length() > 0) {
                        this.realList = this.realList + ",";
                    }
                    this.realList = this.realList + name;
                }
                if (this.list.size() == 0) {
                    this.list = null;
                    this.instanceName = "failover:" + this.source;
                    return null;
                }
                this.instanceName = "failover:" + this.realList + " [" + this.current + "]";
            }
        }
        return this.list.get(this.current);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        SQLException lastException = null;
        while (this.list != null) {
            try {
                return this.getDataSource().getConnection(username, password);
            }
            catch (SQLException e) {
                if (this.list.isEmpty()) {
                    throw e;
                }
                this.doDisconnect();
                lastException = e;
            }
        }
        if (lastException != null) {
            throw lastException;
        }
        throw new SQLException("no DataSource found", lastException);
    }

    @Override
    public void doDisconnect() {
        if (this.list == null) {
            this.instanceName = "failover:" + this.source;
            return;
        }
        ++this.current;
        if (this.current >= this.list.size()) {
            this.list = null;
        }
        this.instanceName = "failover:" + this.realList + " [" + this.current + "]";
    }

    @Override
    public boolean isInstanceConnected() {
        return this.list != null;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
        this.instanceName = "failover:" + source;
    }

    public BundleContext getContext() {
        return this.context;
    }

    public void setContext(BundleContext context) {
        this.context = context;
    }
}

