package de.mhus.lib.karaf.impl;

import java.io.PrintStream;

import org.apache.felix.service.command.CommandSession;
import org.apache.karaf.shell.commands.Action;
import org.apache.karaf.shell.commands.Command;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

import de.mhus.lib.core.console.ConsoleTable;

@Command(scope = "bundle", name = "rawlist", description = "Return the raw list of bundle names")
public class CmdBundleList implements Action  {

	private BundleContext context;

	public Object execute(CommandSession session) throws Exception {
		ConsoleTable table = new ConsoleTable();
		table.getHeader().add("id");
		table.getHeader().add("Bundle");
		table.getHeader().add("Version");
		table.getHeader().add("State");
		for (Bundle b : context.getBundles()) {
			table.addRowValues(""+b.getBundleId(),b.getSymbolicName(),b.getVersion().toString(), toState(b.getState()) );
		}
		table.print(System.out);
		return null;
	}

	private String toState(int state) {
		switch (state) {
			case Bundle.ACTIVE:return "Active";
			case Bundle.INSTALLED: return "Installed";
			case Bundle.RESOLVED: return "Resolved";
			case Bundle.STARTING: return "Starting";
			case Bundle.STOPPING: return "Stopping";
			case Bundle.UNINSTALLED: return "Uninsitalled";
			default: return "" + state;
		}
	}

	public void setContext(BundleContext context) {
        this.context = context;
    }

}
