/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.portlet.callback;

import de.mhus.lib.core.IProperties;
import de.mhus.lib.core.logging.Log;
import de.mhus.lib.core.util.MNls;
import de.mhus.lib.core.util.MNlsProvider;
import de.mhus.lib.errors.MException;
import de.mhus.lib.portlet.callback.AbstractAjaxCallback;
import java.util.LinkedList;
import javax.portlet.PortletSession;
import javax.portlet.ResourceRequest;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.ObjectCodec;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;

public class CallContext
implements MNlsProvider {
    public static final String DEFAULT_DATA_NAME = "data";
    private JsonGenerator response;
    private ObjectMapper mapper;
    private ObjectNode node;
    private MNls nls;
    private LinkedList<Alert> alerts;
    private boolean success = true;
    private ArrayNode result;
    private Log log;
    private ResourceRequest request;
    private IProperties properties;

    public CallContext(AbstractAjaxCallback callback, ResourceRequest request, JsonGenerator response) {
        this.request = request;
        this.response = response;
        this.log = callback.getLog();
        this.nls = callback.getNls();
        this.mapper = new ObjectMapper();
        this.node = this.mapper.createObjectNode();
        this.result = this.node.putArray("results");
        this.properties = callback.createProperties(request);
    }

    public void addSuccess(String msg) {
        this.addAlert(new Alert(Alert.PRIORITY.SUCCESS, msg), true);
    }

    public void addError(String error) {
        this.addAlert(new Alert(Alert.PRIORITY.ERROR, error), true);
    }

    public void addWarning(String warning) {
        this.addAlert(new Alert(Alert.PRIORITY.WARNING, warning), true);
    }

    public void addInforamtion(String info) {
        this.addAlert(new Alert(Alert.PRIORITY.INFO, info), true);
    }

    public void addAlert(Alert alert, boolean useNls) {
        String msg = alert.msg;
        alert.msg = MNls.find((MNlsProvider)this, (String)msg);
        if (this.alerts == null) {
            this.alerts = new LinkedList();
        }
        this.alerts.add(alert);
    }

    public void setRuntimeError(Throwable t) {
        this.log.e(new Object[]{t});
        if (this.alerts != null) {
            this.alerts.clear();
        }
        this.addError(t.toString());
        this.setSuccess(false);
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public void doSend() {
        if (!this.success) {
            this.result.removeAll();
        }
        this.node.put("success", this.success ? 1 : 0);
        if (this.alerts != null) {
            ArrayNode sub = this.node.putArray("alerts");
            for (Alert alert : this.alerts) {
                ObjectNode line = sub.addObject();
                alert.print(line);
            }
        }
        this.response.setCodec((ObjectCodec)this.mapper);
        try {
            this.response.writeTree((JsonNode)this.node);
        }
        catch (Exception e) {
            this.log.e(new Object[]{e});
        }
    }

    public MNls getNls() {
        return this.nls;
    }

    public void setNls(MNls mNls) {
        this.nls = mNls;
    }

    public ResourceRequest getRequest() {
        return this.request;
    }

    public Log log() {
        return this.log;
    }

    public ObjectNode addResult() {
        return this.result.addObject();
    }

    public PortletSession getSession() {
        return this.getRequest().getPortletSession();
    }

    public IProperties getProperties() {
        return this.properties;
    }

    public JsonNode getData() throws MException {
        return this.getData(DEFAULT_DATA_NAME);
    }

    public JsonNode getData(String attributeName) throws MException {
        JsonNode in = null;
        String dataStr = this.getProperties().getString(attributeName);
        if (dataStr != null && !dataStr.equals("undefined")) {
            try {
                JsonFactory f = new JsonFactory();
                ObjectMapper mapper = new ObjectMapper();
                JsonParser parser = f.createJsonParser(dataStr);
                in = mapper.readTree(parser);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return in;
    }

    public static class Alert {
        private PRIORITY type;
        private String msg;

        public Alert(PRIORITY type, String msg) {
            this.type = type;
            this.msg = msg;
        }

        public void print(ObjectNode line) {
            line.put("message", this.msg);
            line.put("priority", this.type.name().toLowerCase());
            if (this.type == PRIORITY.ERROR) {
                line.put("fade", 0);
            }
        }

        public static enum PRIORITY {
            ERROR,
            INFO,
            WARNING,
            SUCCESS;

        }
    }
}

