/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.persistence.aaa;

import de.mhus.lib.adb.DbManager;
import de.mhus.lib.adb.Persistable;
import de.mhus.lib.persistence.aaa.Acl;
import de.mhus.lib.persistence.aaa.AclToSubject;
import de.mhus.lib.persistence.aaa.Subject;
import de.mhus.lib.persistence.aaa.SubjectToSubject;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;

public class AaaUtil {
    public static void findObjectTypes(List<Class<? extends Persistable>> list) {
        list.add(Acl.class);
        list.add(Subject.class);
        list.add(AclToSubject.class);
        list.add(SubjectToSubject.class);
    }

    public static List<Subject> findAffectedSubjects(DbManager manager, Subject user) throws Exception {
        LinkedList<Subject> list = new LinkedList<Subject>();
        list.add(user);
        AaaUtil.addParents(user, list);
        return list;
    }

    private static void addParents(Subject child, List<Subject> list) throws Exception {
        for (SubjectToSubject parent : child.getParents().getRelations()) {
            Subject nextSubject = (Subject)((Object)parent.getParent().getRelation());
            if (list.contains((Object)nextSubject)) continue;
            list.add(nextSubject);
            AaaUtil.addParents(nextSubject, list);
        }
    }

    public static String findPolicyForSubject(DbManager manager, Subject user, Acl acl) throws Exception {
        List<Subject> list = user.getAffectedSubjects(manager);
        for (AclToSubject rule : acl.getRules().getRelations()) {
            UUID subjectId = rule.getSubjectId();
            if (!AaaUtil.contains(list, subjectId)) continue;
            return rule.getPolicy();
        }
        return acl.getDefaultPolicy();
    }

    public static boolean contains(List<Subject> list, UUID subjectId) {
        for (Subject s : list) {
            if (!s.equals(subjectId)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasRight(String right, String policy) {
        return policy.indexOf("[" + right + "]") >= 0;
    }

    public static String createPolicy(String ... rights) {
        StringBuffer out = new StringBuffer();
        for (String right : rights) {
            out.append('[').append(right).append(']');
        }
        return out.toString();
    }
}

