/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.server;

import de.mhus.lib.annotations.jmx.JmxManaged;
import de.mhus.lib.core.MDate;
import de.mhus.lib.core.MStopWatch;
import de.mhus.lib.core.MString;
import de.mhus.lib.core.activator.MutableActivator;
import de.mhus.lib.core.config.IConfig;
import de.mhus.lib.core.config.XmlConfigFile;
import de.mhus.lib.core.console.Console;
import de.mhus.lib.core.io.CSVReader;
import de.mhus.lib.core.jmx.MJmx;
import de.mhus.lib.core.system.DefaultBase;
import de.mhus.lib.core.util.Rfc1738;
import de.mhus.lib.framework.Initializer;
import de.mhus.lib.server.Task;
import de.mhus.lib.server.TaskConfig;
import de.mhus.lib.server.TaskListDefinition;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

@JmxManaged
public class Main
extends MJmx {
    private String actionDate = MDate.toIsoDate((Date)new Date());
    private String status;
    TreeMap<String, TaskListDefinition> lists;
    private TaskConfig initializer;

    public static void main(String[] args) throws Exception {
        new Main().run(args);
    }

    public void run(String[] args) throws Exception {
        boolean exitOnEnd = false;
        ((MutableActivator)((DefaultBase)this.base()).getActivator()).addObject(Main.class, null, (Object)this);
        this.lists = new TreeMap();
        new Initializer((IConfig)new XmlConfigFile(new File("config.xml")), ((DefaultBase)this.base()).getActivator()).initialize();
        Console console = (Console)this.base(Console.class);
        block4: do {
            this.status = "[sleeping]";
            boolean cnt = false;
            console.println("reset: reset execution context");
            for (String name : this.lists.keySet()) {
                console.println((Object)this.lists.get(name));
            }
            if (this.initializer != null) {
                console.println("env=" + this.initializer.getOptions());
                console.println("obj=" + this.initializer.objects());
            }
            console.print("> ");
            String line = null;
            if (args.length > 0) {
                exitOnEnd = true;
                line = MString.join((String[])args, (char)' ');
                args = new String[]{};
            } else {
                line = console.readLine();
                line = line.replace('\n', ' ');
                line = line.replace('\r', ' ');
                line = line.replace('\t', ' ');
                line = line.trim();
            }
            console.println(">>> Execute: " + line);
            if (this.initializer == null) {
                this.resetInitializer();
            }
            if (line.startsWith(">optfile")) {
                line = MString.afterIndex((String)line, (char)' ');
                String file = MString.beforeIndex((String)line, (char)' ');
                line = MString.afterIndex((String)line, (char)' ');
                FileReader r = new FileReader(new File(file));
                CSVReader csv = new CSVReader((Reader)r);
                block6: while (true) {
                    try {
                        while (true) {
                            String[] x;
                            if ((x = csv.getAllFieldsInLine()).length <= 1) {
                                continue;
                            }
                            System.out.println(">>> " + x[0] + "=" + x[1]);
                            HashMap<String, String> defOptions = new HashMap<String, String>();
                            for (int i = 0; i < x.length; i += 2) {
                                defOptions.put(x[i], x[i + 1]);
                            }
                            try {
                                this.execute(line, defOptions);
                                continue block6;
                            }
                            catch (Throwable t) {
                                t.printStackTrace();
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        r.close();
                        continue block4;
                    }
                }
            }
            this.execute(line, null);
        } while (!exitOnEnd);
    }

    private void resetInitializer() throws Exception {
        this.log().i(new Object[]{"reset context"});
        this.initializer = new TaskConfig();
        this.initializer.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(String line, Map<String, String> defOptions) {
        this.actionDate = MDate.toIsoDate((Date)new Date());
        if (!MString.isEmpty((String)line)) {
            String[] parts = MString.split((String)line, (String)" ");
            MStopWatch watch = new MStopWatch("total");
            watch.start();
            try {
                for (String part : parts) {
                    if (!MString.isSetTrim((String)part)) continue;
                    part = part.trim();
                    String optionsString = null;
                    Map options = null;
                    int p = part.indexOf(44);
                    if (p > 0) {
                        optionsString = part.substring(p + 1);
                        part = part.substring(0, p);
                    }
                    if (optionsString != null) {
                        optionsString = optionsString.trim();
                        options = Rfc1738.explode((String)optionsString);
                    }
                    Class<? extends Task>[] commands = null;
                    if (part.equals("reset")) {
                        this.resetInitializer();
                    } else if (this.lists.containsKey(part)) {
                        commands = this.lists.get(part).getTasks();
                    } else {
                        Class<?> command = null;
                        try {
                            command = ((Object)((Object)this)).getClass().getClassLoader().loadClass(part);
                            commands = new Class[]{command};
                        }
                        catch (ClassNotFoundException cnfe) {
                            // empty catch block
                        }
                    }
                    if (commands != null) {
                        for (Class<? extends Task> command : commands) {
                            if (!this.executePass(this.initializer, command, options)) break;
                        }
                        continue;
                    }
                    System.out.println("Command not found: " + part);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                watch.stop();
                System.out.println("TOTAL TIME: " + watch.getCurrentTimeAsString(true));
            }
        }
    }

    private boolean executePass(TaskConfig config, Class<?> command, Map<String, String> options) throws Exception {
        Task p = this.create(config, command);
        p.setOptions(options);
        this.status = ((Object)((Object)p)).getClass().getName();
        return p.run();
    }

    private Task create(TaskConfig initializer, Class<?> clazz) throws Exception {
        Task p = (Task)((Object)clazz.newInstance());
        p.init(initializer);
        return p;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @JmxManaged
    public String getStatus() {
        return this.status;
    }

    public String getActionDate() {
        return this.actionDate;
    }

    public void appendList(TaskListDefinition taskList) {
        this.lists.put(taskList.getName(), taskList);
    }
}

