/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.persistence.aaa;

import de.mhus.lib.adb.IRelationObject;
import de.mhus.lib.adb.model.Field;
import de.mhus.lib.adb.model.FieldRelation;
import de.mhus.lib.core.MString;
import de.mhus.lib.core.MSystem;
import de.mhus.lib.persistence.aaa.DbAccess;
import de.mhus.lib.sql.DbConnection;
import java.util.UUID;

public class RelAcl
implements IRelationObject {
    private UUID acl = null;
    private UUID parentId = null;
    private FieldRelation fieldRelation;
    private Object obj;
    private Field parentField;

    public void prepareCreate() throws Exception {
    }

    public void created(DbConnection con) throws Exception {
        this.loaded(con);
    }

    public void saved(DbConnection con) throws Exception {
        this.loaded(con);
    }

    public void setManager(FieldRelation fieldRelation, Object obj) {
        this.fieldRelation = fieldRelation;
        this.obj = obj;
    }

    public boolean isChanged() {
        return false;
    }

    public void loaded(DbConnection con) {
        try {
            String aclFieldName = "acl";
            String parentFieldName = "parentid";
            DbAccess anno = (DbAccess)MSystem.findAnnotation((Class)this.fieldRelation.getTable().getClazz(), DbAccess.class);
            if (anno != null) {
                aclFieldName = anno.attribute();
                parentFieldName = anno.parent();
            }
            this.acl = (UUID)this.fieldRelation.getTable().getField(aclFieldName).get(this.obj);
            if (MString.isSet((String)parentFieldName)) {
                this.parentField = this.fieldRelation.getTable().getField(parentFieldName);
                if (this.parentField != null) {
                    this.parentId = (UUID)this.parentField.get(this.obj);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void prepareSave(DbConnection con) throws Exception {
    }

    public UUID getValue() {
        return this.acl;
    }

    public boolean isParentChanged() {
        UUID currentId;
        if (this.parentField == null) {
            return false;
        }
        try {
            currentId = (UUID)this.parentField.get(this.obj);
        }
        catch (Exception e) {
            return false;
        }
        return !MSystem.equals((Object)currentId, (Object)this.parentId);
    }
}

