/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.server;

import de.mhus.lib.core.MProperties;
import de.mhus.lib.core.MStopWatch;
import de.mhus.lib.core.directory.DirectoryNode;
import de.mhus.lib.core.jmx.MJmx;
import de.mhus.lib.server.Main;
import de.mhus.lib.server.TaskConfig;
import java.util.Map;

public abstract class Task
extends MJmx {
    protected DirectoryNode config;
    protected TaskConfig base;
    protected MProperties options;

    public static void main(String[] args) throws Exception {
        String taskName = Thread.currentThread().getStackTrace()[1].getClassName();
        Main.main(new String[]{taskName});
    }

    public boolean initAndRun() throws Exception {
        TaskConfig initializer = new TaskConfig();
        initializer.init();
        this.init(initializer);
        return this.run();
    }

    public boolean run() {
        if (this.options == null) {
            this.options = new MProperties();
        }
        if (this.base.getOptions() != null) {
            for (Map.Entry<String, String> entry : this.base.getOptions().entrySet()) {
                if (this.options.isProperty(entry.getKey())) continue;
                this.options.setProperty(entry.getKey(), (Object)entry.getValue());
            }
        }
        boolean ret = true;
        this.log().i(new Object[]{"-----------------------------------------------"});
        this.log().i(new Object[]{">>> EXECUTE", ((Object)((Object)this)).getClass().getCanonicalName(), this.options});
        MStopWatch watch = new MStopWatch(((Object)((Object)this)).getClass().getCanonicalName());
        watch.start();
        try {
            this.pass();
        }
        catch (Throwable t) {
            t.printStackTrace();
            ret = false;
        }
        watch.stop();
        this.log().i(new Object[]{"-----------------------------------------------"});
        this.log().i(new Object[]{"TIME: " + watch.getCurrentTimeAsString()});
        return ret;
    }

    public void init(TaskConfig tc) {
        this.base = tc;
        this.config = this.base.config();
    }

    public abstract void pass() throws Exception;

    public void setOptions(Map<String, String> options) {
        this.options = new MProperties();
        if (options != null) {
            for (Map.Entry<String, String> entry : options.entrySet()) {
                this.options.setProperty(entry.getKey(), (Object)entry.getValue());
            }
        }
    }
}

