/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.persistence.aaa;

import de.mhus.inka.constgenerator.GenerateConstFile;
import de.mhus.lib.adb.DbManager;
import de.mhus.lib.adb.annotations.DbPersistent;
import de.mhus.lib.adb.annotations.DbPrimaryKey;
import de.mhus.lib.adb.annotations.DbRelation;
import de.mhus.lib.adb.relation.RelMultible;
import de.mhus.lib.core.MDate;
import de.mhus.lib.core.MException;
import de.mhus.lib.core.MSystem;
import de.mhus.lib.persistence.aaa.AaaUtil;
import de.mhus.lib.persistence.aaa.DbAccessObject;
import de.mhus.lib.persistence.aaa.SubjectToSubject;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.UUID;

@GenerateConstFile
public class Subject
extends DbAccessObject {
    @DbPrimaryKey
    private UUID id;
    @DbPersistent
    private String loginName;
    @DbPersistent
    private String displayName;
    @DbPersistent
    private Date lastLogin;
    @DbPersistent
    private Date expireDate;
    @DbPersistent
    private Date created;
    @DbPersistent
    private boolean active;
    @DbPersistent
    private String description;
    @DbPersistent
    private String secret;
    @DbPersistent
    private TYPE type;
    @DbRelation(target=SubjectToSubject.class, targetAttribute="parentid")
    private RelMultible<SubjectToSubject> children = new RelMultible();
    @DbRelation(target=SubjectToSubject.class, targetAttribute="childid", managed=false)
    private RelMultible<SubjectToSubject> parents = new RelMultible();
    private List<Subject> affectedList;

    public Subject() {
    }

    public Subject(TYPE type, String loginName) {
        this.type = type;
        this.loginName = loginName;
        this.created = new Date();
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void doLogin(String secret) throws MException {
        if (!this.isAdbManaged()) {
            throw new MException(new Object[]{"subject not managed"});
        }
        if (this.expireDate != null && MDate.isEarlierAs((Date)this.expireDate, (Date)new Date())) {
            throw new MException(new Object[]{"expired"});
        }
        if (this.secret == null || !this.secret.equals(secret)) {
            throw new MException(new Object[]{"login failed"});
        }
        this.lastLogin = new Date();
        this.save();
    }

    public void doExtendExpirationDate(String newSecret) throws MException {
        if (newSecret == null || newSecret.equals(this.secret)) {
            throw new MException(new Object[]{"wrong secret"});
        }
        if (this.expireDate == null) {
            this.expireDate = new Date();
        }
        Calendar c = Calendar.getInstance();
        c.setTime(this.expireDate);
        c.add(2, 1);
        this.secret = newSecret;
        this.expireDate = c.getTime();
        this.save();
    }

    public UUID getId() {
        return this.id;
    }

    public String getLoginName() {
        return this.loginName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Date getLastLogin() {
        return this.lastLogin;
    }

    public Date getExpireDate() {
        return this.expireDate;
    }

    public Date getCreated() {
        return this.created;
    }

    public boolean isActive() {
        return this.active;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public TYPE getType() {
        return this.type;
    }

    public RelMultible<SubjectToSubject> getChildren() {
        return this.children;
    }

    public RelMultible<SubjectToSubject> getParents() {
        return this.parents;
    }

    public boolean equals(Object obj) {
        if (this.id == null) {
            return false;
        }
        if (obj instanceof Subject) {
            return this.id.equals(((Subject)((Object)obj)).getId());
        }
        return this.id.equals(obj);
    }

    public String toString() {
        return MSystem.toString((Object)((Object)this), (Object[])new Object[]{this.type, this.loginName, this.id});
    }

    public synchronized List<Subject> getAffectedSubjects(DbManager manager) throws Exception {
        if (this.affectedList == null) {
            this.affectedList = AaaUtil.findAffectedSubjects(manager, this);
        }
        return this.affectedList;
    }

    public static enum TYPE {
        USER,
        GROUP,
        ROLE;

    }
}

