/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.persistence.aaa;

import de.mhus.lib.adb.AccessDeniedException;
import de.mhus.lib.adb.DbAccessManager;
import de.mhus.lib.adb.DbCollection;
import de.mhus.lib.adb.DbManager;
import de.mhus.lib.adb.model.Field;
import de.mhus.lib.adb.model.FieldRelation;
import de.mhus.lib.adb.model.Table;
import de.mhus.lib.core.MString;
import de.mhus.lib.core.MSystem;
import de.mhus.lib.persistence.aaa.AaaUtil;
import de.mhus.lib.persistence.aaa.Acl;
import de.mhus.lib.persistence.aaa.AclToSubject;
import de.mhus.lib.persistence.aaa.DbAccess;
import de.mhus.lib.persistence.aaa.ISubjectCheck;
import de.mhus.lib.persistence.aaa.RelAcl;
import de.mhus.lib.persistence.aaa.Subject;
import de.mhus.lib.persistence.aaa.SubjectToSubject;
import de.mhus.lib.sql.DbConnection;
import de.mhus.lib.sql.DbResult;
import java.util.HashMap;
import java.util.UUID;

public class AclAccessManager
extends DbAccessManager {
    private ISubjectCheck check;

    public AclAccessManager(ISubjectCheck check) {
        this.check = check;
    }

    public void hasAccess(DbManager manager, Table c, DbConnection con, Object object, int right) throws AccessDeniedException {
        if (this.check.isAdministrator(manager, con)) {
            return;
        }
        if (right == 1) {
            this.hasCreateRight(manager, c, con, object);
            return;
        }
        Object[] list = this.getAcl(manager, con, c, object);
        Acl acl = (Acl)((Object)list[0]);
        boolean publicAccess = (Boolean)list[1];
        String defaultPolicy = (String)list[2];
        boolean isParentChanged = (Boolean)list[3];
        if (publicAccess) {
            return;
        }
        if (right == 2 && isParentChanged) {
            if (!this.hasRight(manager, con, acl, defaultPolicy, "move")) {
                throw new AccessDeniedException(new Object[]{"access denied", this.check.getCurrentUserInfo(), acl, "move", object});
            }
            this.hasCreateRight(manager, c, con, object);
        }
        if (right == 2 && !this.hasRight(manager, con, acl, defaultPolicy, "write")) {
            throw new AccessDeniedException(new Object[]{"access denied", this.check.getCurrentUserInfo(), acl, "write", object});
        }
        if (right == 3 && !this.hasRight(manager, con, acl, defaultPolicy, "remove")) {
            throw new AccessDeniedException(new Object[]{"access denied", this.check.getCurrentUserInfo(), acl, "remove", object});
        }
    }

    private void hasCreateRight(DbManager manager, Table c, DbConnection con, Object object) throws AccessDeniedException {
        if (object instanceof DbResult) {
            throw new AccessDeniedException(new Object[]{"access denied", this.check.getCurrentUserInfo(), object});
        }
        try {
            Class targetClass = c.getClazz();
            DbAccess anno = (DbAccess)MSystem.findAnnotation((Class)targetClass, DbAccess.class);
            String parentFieldName = "parent";
            Class parentType = Class.class;
            String aclFieldName = "acl";
            if (anno != null) {
                parentFieldName = anno.parent();
                parentType = anno.parentType();
                aclFieldName = anno.attribute();
            }
            if (parentType == Class.class) {
                parentType = targetClass;
            }
            if (MString.isEmpty((String)parentFieldName)) {
                return;
            }
            Table parentTable = null;
            Field parentField = c.getField(parentFieldName);
            Object parentValue = parentField.get(object);
            if (parentValue == null) {
                throw new AccessDeniedException(new Object[]{"access denied: parent is null", this.check.getCurrentUserInfo(), object});
            }
            UUID parentId = null;
            Object parent = null;
            if (parentValue instanceof UUID) {
                parentId = (UUID)parentValue;
            } else {
                String parentIdStr = parentValue.toString();
                if (parentIdStr.startsWith("from ")) {
                    String query = MString.afterIndex((String)parentIdStr, (char)' ');
                    String from = MString.beforeIndex((String)query, (char)' ').trim();
                    if (!(query = MString.afterIndex((String)query, (char)' ').trim()).startsWith("where ")) {
                        throw new AccessDeniedException(new Object[]{"access denied: syntax error", this.check.getCurrentUserInfo(), object, parentIdStr});
                    }
                    query = MString.afterIndex((String)query, (char)' ').trim();
                    from = from.toLowerCase();
                    parentTable = manager.getTable(from);
                    parentType = parentTable.getClazz();
                    HashMap<String, Object> attributes = new HashMap<String, Object>();
                    for (Field f : c.getFields()) {
                        attributes.put(f.getMappedName(), f.get(object));
                    }
                    DbCollection res = manager.getByQualification(con, manager.createSchemaObject(from), from, query, attributes);
                    if (res.hasNext()) {
                        parent = res.next();
                    }
                    res.close();
                } else {
                    parentId = UUID.fromString(parentIdStr);
                }
            }
            if (parentTable == null && (parentTable = manager.getTable(manager.getRegistryName(parentType))) == null) {
                throw new AccessDeniedException(new Object[]{"access denied: parent type not found", this.check.getCurrentUserInfo(), object, parentType});
            }
            if (parent == null) {
                parent = manager.getObject(con, parentType, new Object[]{parentId});
            }
            if (parent == null) {
                throw new AccessDeniedException(new Object[]{"access denied: parent not found", this.check.getCurrentUserInfo(), object, parentId});
            }
            Object[] list = this.getAcl(manager, con, parentTable, parent);
            Acl acl = (Acl)((Object)list[0]);
            boolean publicAccess = (Boolean)list[1];
            String defaultPolicy = (String)list[2];
            if (publicAccess) {
                return;
            }
            if (!this.hasRight(manager, con, acl, defaultPolicy, "create")) {
                throw new AccessDeniedException(new Object[]{"access denied", this.check.getCurrentUserInfo(), acl, "create", object, parent});
            }
            String childAclFieldName = "childacl";
            DbAccess pAnno = (DbAccess)MSystem.findAnnotation((Class)parentType, DbAccess.class);
            if (pAnno != null) {
                childAclFieldName = pAnno.childAcl();
            }
            if (MString.isEmpty((String)childAclFieldName)) {
                return;
            }
            Field aclField = c.getField(aclFieldName);
            Field childAclField = parentTable.getField(childAclFieldName);
            Object childAcl = childAclField.get(parent);
            aclField.set(object, childAcl);
        }
        catch (AccessDeniedException ade) {
            throw ade;
        }
        catch (Exception e) {
            throw new AccessDeniedException(new Object[]{"error", e});
        }
    }

    public boolean hasRight(DbManager manager, DbConnection con, Acl acl, String defaultPolicy, String right) {
        return this.check.hasRight(manager, con, acl, right) || AaaUtil.hasRight(defaultPolicy, right) || this.check.hasRight(manager, con, acl, "all") || AaaUtil.hasRight(defaultPolicy, "all") || this.check.isAdministrator(manager, con);
    }

    public void hasReadAccess(DbManager manager, Table c, DbConnection con, DbResult ret) throws AccessDeniedException {
        if (this.check.isAdministrator(manager, con)) {
            return;
        }
        if (c.getClazz() == Subject.class || c.getClazz() == Acl.class || c.getClazz() == SubjectToSubject.class || c.getClazz() == AclToSubject.class) {
            return;
        }
        try {
            Object[] list = this.getAcl(manager, con, c, ret);
            Acl acl = (Acl)((Object)list[0]);
            boolean publicAccess = (Boolean)list[1];
            String defaultPolicy = (String)list[2];
            if (publicAccess) {
                return;
            }
            if (!this.hasRight(manager, con, acl, defaultPolicy, "read")) {
                throw new AccessDeniedException(new Object[]{"access denied", this.check.getCurrentUserInfo(), acl, "read"});
            }
        }
        catch (Exception e) {
            throw new AccessDeniedException(new Object[]{e});
        }
    }

    public Object[] getAcl(DbManager manager, DbConnection con, Table c, Object object) {
        Class targetClass = c.getClazz();
        String aclFieldName = "acl";
        String aclOriginalName = "acloriginal";
        String defaultPolicy = "";
        String ownerFieldName = "";
        Class<?> ownerType = null;
        Acl aclObj = null;
        boolean publicAccess = true;
        boolean isParentChanged = false;
        DbAccess anno = (DbAccess)MSystem.findAnnotation((Class)targetClass, DbAccess.class);
        if (anno != null) {
            publicAccess = false;
            aclFieldName = anno.attribute();
            aclOriginalName = anno.original();
            defaultPolicy = anno.worldAccess();
            ownerFieldName = anno.owner();
            ownerType = anno.ownerType();
        }
        try {
            if (MString.isSet((String)ownerFieldName)) {
                Field ownerField = c.getField(ownerFieldName);
                Object ownerValueObj = null;
                ownerValueObj = object instanceof DbResult ? ((DbResult)object).getString(ownerField.getMappedName()) : ownerField.get(object);
                UUID ownerId = null;
                Object ownerObj = null;
                ownerId = ownerValueObj instanceof UUID ? (UUID)ownerValueObj : UUID.fromString(ownerValueObj.toString());
                if (ownerId != null) {
                    ownerObj = manager.getObject(con, ownerType, new Object[]{ownerId});
                }
                if (ownerObj == null) {
                    return null;
                }
                return this.getAcl(manager, con, manager.getTable(manager.getRegistryName(ownerObj)), ownerObj);
            }
            Field aclField = c.getField(aclFieldName);
            FieldRelation originalField = c.getFieldRelation(aclOriginalName);
            if (aclField != null) {
                publicAccess = false;
                Object aclValueObj = null;
                if (object instanceof DbResult) {
                    aclValueObj = ((DbResult)object).getString(aclField.getMappedName());
                } else if (originalField != null) {
                    aclValueObj = ((RelAcl)originalField.getRelationObject(object)).getValue();
                    isParentChanged = ((RelAcl)originalField.getRelationObject(object)).isParentChanged();
                } else {
                    aclValueObj = aclField.get(object);
                }
                if (aclValueObj != null) {
                    UUID aclId = null;
                    aclId = aclValueObj instanceof UUID ? (UUID)aclValueObj : UUID.fromString(aclValueObj.toString());
                    if (aclId != null) {
                        aclObj = (Acl)((Object)manager.getObject(con, Acl.class, new Object[]{aclId}));
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new Object[]{aclObj, publicAccess, defaultPolicy, isParentChanged};
    }
}

