/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.jmx;

import com.sun.jdmk.comm.AuthInfo;
import com.sun.jdmk.comm.HtmlAdaptorServer;
import de.mhus.lib.core.MException;
import de.mhus.lib.core.MPassword;
import de.mhus.lib.core.directory.DirectoryNode;
import de.mhus.lib.core.jmx.JmxManaged;
import de.mhus.lib.core.jmx.MJmx;
import de.mhus.lib.core.jmx.MRemoteManager;
import de.mhus.lib.core.service.ConfigProvider;
import javax.management.ObjectName;

@JmxManaged(descrition="Jmx Http Server")
public class JmxHttpServer
extends MJmx {
    private HtmlAdaptorServer server;
    private DirectoryNode config;

    public void setConfig(DirectoryNode config) {
        this.config = config;
    }

    @JmxManaged
    public void openServer() throws MException {
        if (this.config == null) {
            this.config = ((ConfigProvider)this.base(ConfigProvider.class)).getConfig((Object)this, null);
        }
        if (this.config == null || this.server != null) {
            return;
        }
        this.server = new HtmlAdaptorServer(this.config.getInt("port", 1098));
        for (DirectoryNode cuser : this.config.getNodes("user")) {
            this.server.addUserAuthenticationInfo(new AuthInfo(cuser.getExtracted("name"), MPassword.decode((String)cuser.getExtracted("password"))));
        }
        try {
            ((MRemoteManager)this.base(MRemoteManager.class)).register(new ObjectName("adaptor:proptocol=HTTP"), (Object)this.server, false, false);
            this.server.setMBeanServer(((MRemoteManager)this.base(MRemoteManager.class)).getMBeanServer());
        }
        catch (Exception e) {
            this.log().w(new Object[]{e});
            this.server = null;
            return;
        }
        this.server.start();
    }

    @JmxManaged
    public void closeServer() {
        if (this.server == null) {
            return;
        }
        this.server.stop();
        this.server = null;
    }
}

