/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.framework;

import de.mhus.lib.core.MActivator;
import de.mhus.lib.core.MException;
import de.mhus.lib.core.MPassword;
import de.mhus.lib.core.MString;
import de.mhus.lib.core.config.IConfig;
import de.mhus.lib.core.directory.DirectoryNode;
import de.mhus.lib.core.jmx.JmxManaged;
import de.mhus.lib.core.jmx.MJmx;
import de.mhus.lib.core.lang.MutableActivator;
import java.lang.reflect.Method;

@JmxManaged(descrition="Initializer management interface")
public class Initializer
extends MJmx {
    private IConfig config;
    private MActivator base;

    public Initializer(IConfig config, MActivator base) {
        this.config = config;
        this.base = base;
    }

    public void initialize() {
        if (this.base instanceof MutableActivator) {
            ((MutableActivator)this.base).addObject(IConfig.class, null, (Object)this.config);
            ((MutableActivator)this.base).addObject(Initializer.class, null, (Object)this);
        }
        DirectoryNode cInit = this.config.getNode("initialize");
        for (DirectoryNode cStart : cInit.getNodes("start")) {
            try {
                String clazz = cStart.getExtracted("class");
                String interf = cStart.getExtracted("interface");
                String method = cStart.getExtracted("method");
                this.start(clazz, interf, method);
            }
            catch (Throwable t) {
                this.log().e(new Object[]{t});
            }
        }
        this.jmxRegister(true, ((Object)((Object)this)).getClass().getCanonicalName());
    }

    @JmxManaged(descrition="Call System.exit, give the secret from configuration for security. p1=return code, p2=secret")
    public void exit(int rc, String secret) {
        if (!this.hasSuperPrivileges(secret)) {
            return;
        }
        this.log().i(new Object[]{"Exit by user request via jmx"});
        System.exit(rc);
    }

    private boolean hasSuperPrivileges(String secret) {
        if (secret == null) {
            return false;
        }
        try {
            return secret.equals(MPassword.decode((String)this.config.getString("secret", null)));
        }
        catch (MException mException) {
            return false;
        }
    }

    @JmxManaged(descrition="This is a simple helpfull function to encode a password on the running system (see MPassword). p1=encoding algorithm, p2=password to encode")
    public String encodePassword(int method, String in) {
        return MPassword.encode((int)method, (String)in);
    }

    @JmxManaged(descrition="Start a service, p1=class, p2=interface, p3=method")
    public void start(String clazz, String interf, String method) throws Exception {
        this.log().i(new Object[]{"start", clazz});
        Object obj = this.base.getObject(clazz);
        if (interf != null && this.base instanceof MutableActivator) {
            this.log().i(new Object[]{"interface", interf});
            ((MutableActivator)this.base).addObject(null, interf, obj);
        }
        if (MString.isSet((String)method)) {
            this.log().i(new Object[]{"method", method});
            Method me = obj.getClass().getMethod(method, new Class[0]);
            me.invoke(obj, new Object[0]);
        }
        this.log().i(new Object[]{"finished", clazz});
    }

    @JmxManaged
    public String[] getMapNames() {
        if (!(this.base instanceof MutableActivator)) {
            return null;
        }
        return ((MutableActivator)this.base).getMapNames();
    }

    @JmxManaged
    public String[] getObjectNames() {
        if (!(this.base instanceof MutableActivator)) {
            return null;
        }
        return ((MutableActivator)this.base).getObjectNames();
    }
}

