/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.vault;

import de.mhus.lib.core.MProperties;
import de.mhus.lib.core.MSystem;
import de.mhus.lib.core.MValidator;
import de.mhus.lib.core.util.SecureString;
import de.mhus.lib.core.vault.MapMutableVaultSource;
import de.mhus.lib.core.vault.MutableVaultSource;
import de.mhus.lib.core.vault.VaultEntry;
import java.io.File;
import java.io.IOException;
import java.util.UUID;

public class VaultSourceFromPlainProperties
extends MapMutableVaultSource {
    private boolean editable;
    private File file;
    private long fileModified;
    private boolean fileCanWrite;

    public VaultSourceFromPlainProperties(File file, boolean editable, String name) throws IOException {
        this.file = file;
        this.name = name;
        this.editable = editable;
        if (file.exists()) {
            this.doLoad();
        }
    }

    @Override
    public void doLoad() throws IOException {
        this.entries.clear();
        MProperties prop = MProperties.load(this.file);
        for (String key : prop.keys()) {
            if (!MValidator.isUUID(key)) continue;
            PlainEntry entry = new PlainEntry(prop, this.name);
            this.entries.put(UUID.fromString(this.name), entry);
        }
        this.fileModified = this.file.lastModified();
        this.fileCanWrite = this.file.canWrite();
    }

    @Override
    public void doSave() throws IOException {
        MProperties out = new MProperties();
        for (VaultEntry entry : this.entries.values()) {
            out.setString(entry.getId().toString(), entry.getValue().value());
            out.setString(entry.getId() + ".name", entry.getName());
            out.setString(entry.getId() + ".type", entry.getType());
            out.setString(entry.getId() + ".desc", entry.getDescription());
        }
        out.save(this.file);
        this.fileModified = this.file.lastModified();
    }

    @Override
    public boolean isMemoryBased() {
        return true;
    }

    @Override
    public MutableVaultSource getEditable() {
        if (!this.editable || !this.fileCanWrite) {
            return null;
        }
        return this;
    }

    @Override
    public String toString() {
        return MSystem.toString(this, this.name, this.entries.size(), this.file);
    }

    @Override
    protected void doCheckSource() {
        if (this.file.lastModified() != this.fileModified) {
            try {
                this.doLoad();
            }
            catch (IOException e) {
                this.log().e(this.file, e);
            }
        }
    }

    private class PlainEntry
    implements VaultEntry {
        private UUID id;
        private SecureString value;
        private String name;
        private String type;
        private String desc;

        public PlainEntry(MProperties prop, String name) {
            this.id = UUID.fromString(name);
            this.value = new SecureString(prop.getString(name, null));
            name = prop.getString(name + ".name", "");
            this.type = prop.getString(name + ".type", "");
            this.desc = prop.getString(name + ".desc", "");
        }

        @Override
        public UUID getId() {
            return this.id;
        }

        @Override
        public String getType() {
            return this.type;
        }

        @Override
        public String getDescription() {
            return this.desc;
        }

        @Override
        public SecureString getValue() {
            return this.value;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

