/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.vault;

import de.mhus.lib.core.MApi;
import de.mhus.lib.core.MLog;
import de.mhus.lib.core.cfg.CfgBoolean;
import de.mhus.lib.core.cfg.CfgFile;
import de.mhus.lib.core.vault.MVault;
import de.mhus.lib.core.vault.MapMutableVaultSource;
import de.mhus.lib.core.vault.VaultPassphrase;
import de.mhus.lib.core.vault.VaultSource;
import de.mhus.lib.core.vault.VaultSourceFactory;
import de.mhus.lib.core.vault.VaultSourceFromPlainJson;
import de.mhus.lib.core.vault.VaultSourceFromPlainProperties;
import de.mhus.lib.core.vault.VaultSourceFromSecFile;
import de.mhus.lib.core.vault.VaultSourceFromSecFolder;
import java.io.File;
import java.io.IOException;

public class DefaultVaultSourceFactory
extends MLog
implements VaultSourceFactory {
    private static CfgFile CFG_DEFAULT_FILE = new CfgFile((Object)MVault.class, "file", MApi.getFile(MApi.SCOPE.ETC, "de.mhus.lib.core.vault.FileVaultSource.dat"));
    private static CfgFile CFG_DEFAULT_FOLDER = new CfgFile((Object)MVault.class, "folder", MApi.getFile(MApi.SCOPE.DATA, "de.mhus.lib.core.vault.FolderVaultSource"));
    private static CfgBoolean CFG_EDITABLE = new CfgBoolean((Object)VaultSourceFromPlainProperties.class, "editable", false);

    @Override
    public VaultSource create(String name, VaultPassphrase vaultPassphrase) {
        MapMutableVaultSource def = null;
        if ("default".equals(name)) {
            if (((File)CFG_DEFAULT_FILE.value()).exists()) {
                if (((File)CFG_DEFAULT_FILE.value()).getName().endsWith(".json")) {
                    try {
                        def = new VaultSourceFromPlainJson((File)CFG_DEFAULT_FILE.value(), (Boolean)CFG_EDITABLE.value(), name);
                    }
                    catch (IOException e) {
                        this.log().d(e);
                    }
                } else if (((File)CFG_DEFAULT_FILE.value()).getName().endsWith(".properties")) {
                    try {
                        def = new VaultSourceFromPlainProperties((File)CFG_DEFAULT_FILE.value(), (Boolean)CFG_EDITABLE.value(), name);
                    }
                    catch (IOException e) {
                        this.log().d(e);
                    }
                } else {
                    try {
                        def = new VaultSourceFromSecFile((File)CFG_DEFAULT_FILE.value(), vaultPassphrase.getPassphrase(), name);
                    }
                    catch (IOException e) {
                        this.log().d(e);
                    }
                }
            } else {
                try {
                    def = new VaultSourceFromSecFolder((File)CFG_DEFAULT_FOLDER.value(), vaultPassphrase.getPassphrase(), name);
                }
                catch (IOException e) {
                    this.log().w(e);
                }
            }
        } else {
            File file = new File(name);
            if (file.exists() && file.isFile()) {
                try {
                    def = new VaultSourceFromSecFile(file, vaultPassphrase.getPassphrase(), file.getName());
                }
                catch (IOException e) {
                    this.log().d(e);
                }
            } else {
                try {
                    def = new VaultSourceFromSecFolder(file, vaultPassphrase.getPassphrase(), file.getName());
                }
                catch (IOException e) {
                    this.log().w(e);
                }
            }
        }
        return def;
    }
}

