/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.util;

import de.mhus.lib.core.MCollection;
import de.mhus.lib.core.MPeriod;
import de.mhus.lib.core.MThread;
import de.mhus.lib.core.logging.Log;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeoutException;

public class AtomicClockUtil {
    private static Log log = Log.getLog(AtomicClockUtil.class);
    private static final long TIMEOUT_RELOAD = 1800000L;
    private static long lastUpdate;
    private static long now;
    public static final List<String> TIME_SERVERS;
    private static int currentServer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getAtomicTime(String timeServerInternet) throws UnknownHostException, IOException, TimeoutException {
        long secondsSince1900 = 0L;
        long miliSecondsSince1970 = 0L;
        long[] buffer = new long[4];
        boolean readedTime = false;
        int i = 0;
        long timeout = 6000L;
        Socket socket = new Socket(timeServerInternet, 37);
        InputStream is = socket.getInputStream();
        OutputStream os = socket.getOutputStream();
        try {
            while (!readedTime) {
                if (is.available() >= 4) {
                    for (i = 0; i < 4; ++i) {
                        buffer[i] = is.read();
                    }
                    readedTime = true;
                }
                if (readedTime) continue;
                MThread.sleep(10L);
                if (--timeout > 0L) continue;
                throw new TimeoutException();
            }
        }
        finally {
            is.close();
            os.close();
            socket.close();
        }
        secondsSince1900 = buffer[0] * 0x1000000L + buffer[1] * 65536L + buffer[2] * 256L + buffer[3];
        miliSecondsSince1970 = secondsSince1900 - Long.parseLong("2208988800");
        return miliSecondsSince1970 *= 1000L;
    }

    public static synchronized long getCurrentTime() {
        if (MPeriod.isTimeOut(lastUpdate, 1800000L)) {
            for (int i = 0; i < TIME_SERVERS.size(); ++i) {
                try {
                    now = AtomicClockUtil.getAtomicTime(TIME_SERVERS.get(currentServer));
                    lastUpdate = System.currentTimeMillis();
                    return now;
                }
                catch (Throwable t) {
                    log.i(t);
                    currentServer = (currentServer + 1) % TIME_SERVERS.size();
                    continue;
                }
            }
        }
        return now + (System.currentTimeMillis() - lastUpdate);
    }

    public static void main(String[] args) {
        for (int i = 0; i < 100; ++i) {
            long atomic = AtomicClockUtil.getCurrentTime();
            long local = System.currentTimeMillis();
            System.out.println("Atomic: " + atomic);
            System.out.println("Local : " + local + "     " + (atomic - local));
            System.out.flush();
            MThread.sleep(100L);
        }
    }

    static {
        TIME_SERVERS = new LinkedList<String>(MCollection.toList("time-a.timefreq.bldrdoc.gov", "time-a.timefreq.bldrdoc.gov", "time-b.timefreq.bldrdoc.gov", "time-c.timefreq.bldrdoc.gov", "utcnist.colorado.edu", "time-nw.nist.gov", "nist1.nyc.certifiedtime.com", "nist1.dc.certifiedtime.com", "nist1.sjc.certifiedtime.com", "nist1.datum.com", "ntp2.cmc.ec.gc.ca", "ntps1-0.uni-erlangen.de", "ntps1-1.uni-erlangen.de", "ntps1-2.uni-erlangen.de", "ntps1-0.cs.tu-berlin.de", "time.ien.it", "ptbtime1.ptb.de", "ptbtime2.ptb.de"));
        currentServer = 0;
    }
}

