/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.parser;

import de.mhus.lib.core.MString;
import de.mhus.lib.core.MSystem;
import de.mhus.lib.core.parser.CompiledString;
import de.mhus.lib.core.parser.Parser;
import de.mhus.lib.core.parser.StringPart;
import de.mhus.lib.errors.MException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class StringCompiler
implements Parser {
    private static StringCompiler defaultCompiler = new StringCompiler();
    protected String separator = "$";

    public static CompiledString compile(String in) {
        return StringCompiler.compile(in, defaultCompiler);
    }

    public static CompiledString compile(String in, StringCompiler compiler) {
        return compiler.compileString(in);
    }

    @Override
    public CompiledString compileString(String in) {
        LinkedList<StringPart> compiled = new LinkedList<StringPart>();
        List<String> parts = this.splitString(in);
        boolean c = true;
        for (String part : parts) {
            if (c) {
                compiled.add(this.createContentPart(part));
                c = false;
                continue;
            }
            if (part.length() == 0) {
                compiled.add(this.createContentPart(this.separator));
            } else {
                compiled.add(this.createAttributePart(part));
            }
            c = true;
        }
        return new CompiledString(compiled);
    }

    protected List<String> splitString(String in) {
        LinkedList<String> parts = new LinkedList<String>();
        while (in.length() != 0) {
            int endPos;
            int nextPos = in.indexOf(this.separator);
            if (nextPos < 0) {
                parts.add(in);
                return parts;
            }
            parts.add(in.substring(0, nextPos));
            if (nextPos == in.length() - this.separator.length()) {
                parts.add(this.separator);
                return parts;
            }
            if (in.charAt(nextPos + this.separator.length()) == '{') {
                endPos = in.indexOf(125, nextPos);
                if (endPos < 0) {
                    parts.add(in.substring(nextPos));
                    return parts;
                }
                parts.add(in.substring(nextPos + this.separator.length() + 1, endPos));
                in = in.substring(endPos + 1);
                continue;
            }
            endPos = in.indexOf(this.separator, nextPos + this.separator.length());
            if (endPos < 0) {
                parts.add(in.substring(nextPos));
                return parts;
            }
            parts.add(in.substring(nextPos + this.separator.length(), endPos));
            in = in.substring(endPos + this.separator.length());
        }
        return parts;
    }

    protected StringPart createAttributePart(String part) {
        if (part.startsWith("#env.")) {
            return new EnvironmentPart(part);
        }
        if (part.startsWith("#system.")) {
            return new SystemPart(part);
        }
        if (part.equals("#hostname")) {
            return new StaticPart(MSystem.getHostname());
        }
        if (part.equals("#username")) {
            return new StaticPart(MSystem.getUsername());
        }
        if (part.equals("#userhome")) {
            return new StaticPart(MSystem.getUserHome().getAbsolutePath());
        }
        return this.createDefaultAttributePart(part);
    }

    protected StringPart createDefaultAttributePart(String part) {
        return new AttributePart(part);
    }

    protected StringPart createContentPart(String part) {
        return new ContentPart(part);
    }

    public class AttributePart
    implements StringPart {
        private String name;
        private String def;

        public AttributePart(String part) {
            this.name = part;
            int p = this.name.indexOf(58);
            if (p >= 0) {
                this.def = this.name.substring(p + 1);
                this.name = this.name.substring(0, p);
            }
        }

        @Override
        public void execute(StringBuilder out, Map<String, Object> attributes) {
            if (attributes != null) {
                out.append(attributes.getOrDefault(this.name, this.def));
            }
        }

        @Override
        public void dump(int level, StringBuilder out) {
            MString.appendRepeating(level, ' ', out);
            out.append(this.getClass().getCanonicalName()).append(" ").append(this.name).append(':').append(this.def).append("\n");
        }
    }

    public class SystemPart
    implements StringPart {
        private String name;
        private String def;

        public SystemPart(String part) {
            this.name = MString.afterIndex(part, '.');
            int p = this.name.indexOf(58);
            if (p >= 0) {
                this.def = this.name.substring(p + 1);
                this.name = this.name.substring(0, p);
            }
        }

        @Override
        public void execute(StringBuilder out, Map<String, Object> attributes) {
            out.append(System.getProperty(this.name, this.def));
        }

        @Override
        public void dump(int level, StringBuilder out) {
            MString.appendRepeating(level, ' ', out);
            out.append(this.getClass().getCanonicalName()).append(" ").append(this.name).append(':').append(this.def).append("\n");
        }
    }

    public class StaticPart
    implements StringPart {
        private String value;

        public StaticPart(String value) {
            this.value = value;
        }

        @Override
        public void execute(StringBuilder out, Map<String, Object> attributes) throws MException {
            out.append(this.value);
        }

        @Override
        public void dump(int level, StringBuilder out) {
            MString.appendRepeating(level, ' ', out);
            out.append(this.getClass().getCanonicalName()).append(" '").append(this.value).append("'\n");
        }
    }

    public class EnvironmentPart
    implements StringPart {
        private String name;
        private String def;

        public EnvironmentPart(String part) {
            this.name = MString.afterIndex(part, '.');
            int p = this.name.indexOf(58);
            if (p >= 0) {
                this.def = this.name.substring(p + 1);
                this.name = this.name.substring(0, p);
            }
        }

        @Override
        public void execute(StringBuilder out, Map<String, Object> attributes) {
            String v = System.getenv(this.name);
            if (v == null) {
                v = this.def;
            }
            out.append(v);
        }

        @Override
        public void dump(int level, StringBuilder out) {
            MString.appendRepeating(level, ' ', out);
            out.append(this.getClass().getCanonicalName()).append(" ").append(this.name).append(':').append(this.def).append('\n');
        }
    }

    public class ContentPart
    implements StringPart {
        private String content;

        public ContentPart(String part) {
            this.content = part;
        }

        @Override
        public void execute(StringBuilder out, Map<String, Object> attributes) {
            out.append(this.content);
        }

        @Override
        public void dump(int level, StringBuilder out) {
            MString.appendRepeating(level, ' ', out);
            out.append(this.getClass().getCanonicalName()).append(" ").append(this.content).append("\n");
        }
    }
}

