/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.matcher;

import de.mhus.lib.core.MValidator;
import de.mhus.lib.core.matcher.Context;
import de.mhus.lib.core.matcher.ModelAnd;
import de.mhus.lib.core.matcher.ModelComposit;
import de.mhus.lib.core.matcher.ModelFs;
import de.mhus.lib.core.matcher.ModelNumber;
import de.mhus.lib.core.matcher.ModelOr;
import de.mhus.lib.core.matcher.ModelPart;
import de.mhus.lib.core.matcher.ModelPattern;
import de.mhus.lib.core.matcher.ModelRegex;
import de.mhus.lib.core.matcher.ModelSql;
import de.mhus.lib.core.matcher.ModelVariable;
import de.mhus.lib.core.matcher.NullPattern;
import de.mhus.lib.core.parser.StringTokenizerParser;
import de.mhus.lib.core.parser.TechnicalStringParser;
import de.mhus.lib.errors.MException;
import de.mhus.lib.errors.SyntaxError;
import java.util.Map;

public class Condition {
    ModelComposit root = null;

    public Condition(String condition) throws MException {
        TechnicalStringParser tokenizer = new TechnicalStringParser(condition);
        tokenizer.setBreakableCharacters("()!");
        this.parse(tokenizer);
    }

    public boolean matches(Map<String, ?> map) {
        if (map == null) {
            return false;
        }
        return this.root.m(map);
    }

    protected void parse(StringTokenizerParser condition) throws MException {
        this.root = null;
        ModelPattern pattern = null;
        String param = null;
        Context context = new Context();
        ModelPattern.CONDITION cond = ModelPattern.CONDITION.EQ;
        for (String part : condition) {
            if (part == null) continue;
            String lp = part.toLowerCase();
            boolean isPattern = false;
            if (condition.isEnclosuredToken()) {
                isPattern = true;
            } else {
                switch (lp) {
                    case "not": 
                    case "!": {
                        context.not = true;
                        break;
                    }
                    case "and": 
                    case "&&": {
                        if (context.not) {
                            throw new SyntaxError(new Object[]{"not before operator"});
                        }
                        if (pattern != null) {
                            throw new SyntaxError(new Object[]{"type before operator"});
                        }
                        if (context.current != null && context.current instanceof ModelAnd) break;
                        Object next = new ModelAnd();
                        if (param == null && context.current != null) {
                            param = context.current.getParamName();
                        }
                        ((ModelPart)next).setParamName(param);
                        context.append((ModelComposit)next);
                        break;
                    }
                    case "or": 
                    case "||": {
                        if (context.not) {
                            throw new SyntaxError(new Object[]{"not before operator"});
                        }
                        if (pattern != null) {
                            throw new SyntaxError(new Object[]{"type before operator"});
                        }
                        if (context.current != null && context.current instanceof ModelAnd) break;
                        Object next = new ModelOr();
                        if (param == null && context.current != null) {
                            param = context.current.getParamName();
                        }
                        ((ModelPart)next).setParamName(param);
                        context.append((ModelComposit)next);
                        break;
                    }
                    case "(": {
                        Object next = new Context();
                        ((Context)next).parentContext = context;
                        context = next;
                        break;
                    }
                    case ")": {
                        if (context.parent == null) {
                            throw new SyntaxError(new Object[]{"can't close bracket"});
                        }
                        Context last = context;
                        context = context.parentContext;
                        ModelComposit next = last.findRoot();
                        if (last.current == null && last.first != null) {
                            ModelAnd and = new ModelAnd();
                            and.setNot(last.not);
                            last.current = and;
                        } else {
                            next.setNot(context.not);
                        }
                        context.append(next);
                        break;
                    }
                    case "number": {
                        if (pattern != null) {
                            throw new SyntaxError(new Object[]{"type before type"});
                        }
                        pattern = new ModelNumber();
                        break;
                    }
                    case "fs": {
                        if (pattern != null) {
                            throw new SyntaxError(new Object[]{"type before type"});
                        }
                        pattern = new ModelFs();
                        break;
                    }
                    case "sql": {
                        if (pattern != null) {
                            throw new SyntaxError(new Object[]{"type before type"});
                        }
                        pattern = new ModelSql();
                        break;
                    }
                    case "regex": {
                        if (pattern != null) {
                            throw new SyntaxError(new Object[]{"type before type"});
                        }
                        pattern = new ModelRegex();
                        break;
                    }
                    case "null": {
                        pattern = new NullPattern();
                        isPattern = true;
                        break;
                    }
                    case "var": {
                        if (pattern != null) {
                            throw new SyntaxError(new Object[]{"type before type"});
                        }
                        pattern = new ModelVariable();
                        break;
                    }
                    case "is": 
                    case "==": {
                        cond = ModelPattern.CONDITION.EQ;
                        break;
                    }
                    case "lt": 
                    case "<": {
                        cond = ModelPattern.CONDITION.LT;
                        break;
                    }
                    case "le": 
                    case "<=": {
                        cond = ModelPattern.CONDITION.LE;
                        break;
                    }
                    case "ge": 
                    case ">=": {
                        cond = ModelPattern.CONDITION.GE;
                        break;
                    }
                    case "gr": 
                    case ">": {
                        cond = ModelPattern.CONDITION.GR;
                        break;
                    }
                    default: {
                        isPattern = true;
                    }
                }
            }
            if (isPattern && param == null && !condition.isEnclosuredToken() && lp.startsWith("$")) {
                param = part.substring(1);
                if (param.startsWith("{") && param.endsWith("}")) {
                    param = param.substring(1, param.length() - 1);
                }
                isPattern = false;
            }
            if (!isPattern) continue;
            if (context.current == null && context.first != null) {
                throw new SyntaxError(new Object[]{"pattern after pattern without operation"});
            }
            if (param == null) {
                param = context.current.getParamName();
            }
            if (param == null) {
                throw new SyntaxError(new Object[]{"pattern without parameter name"});
            }
            if (pattern == null) {
                pattern = part.startsWith("${") ? new ModelVariable() : (MValidator.isNumber(part) ? new ModelNumber() : new ModelRegex());
            }
            pattern.setCondition(cond);
            pattern.setParamName(param);
            pattern.setPattern(part);
            pattern.setNot(context.not);
            if (context.current == null) {
                context.first = pattern;
            } else {
                context.current.add(pattern);
            }
            context.not = false;
            pattern = null;
            param = null;
            cond = ModelPattern.CONDITION.EQ;
        }
        if (context.parentContext != null) {
            throw new SyntaxError(new Object[]{"bracked not closed"});
        }
        this.root = context.findRoot();
    }

    public String toString() {
        return this.root == null ? "[null]" : this.root.toString();
    }
}

