/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.crypt.pem;

import de.mhus.lib.core.crypt.pem.PemBlock;
import de.mhus.lib.core.crypt.pem.PemUtil;
import de.mhus.lib.core.util.SecureString;
import java.security.PrivateKey;

public class SecurityPrivateKey
implements PrivateKey {
    private static final long serialVersionUID = 1L;
    private String algorithm;
    private String format;
    private byte[] encoded;

    public SecurityPrivateKey(PemBlock pem, SecureString passphrase) throws Exception {
        if (!PemUtil.isPrivKey(pem)) {
            throw new SecurityException("Block is not a private key: " + pem.getName());
        }
        this.algorithm = pem.getString("Method", "");
        this.format = pem.getString("Format", "");
        this.encoded = pem.getBytesBlock();
        if (passphrase != null) {
            this.encoded = PemUtil.decrypt(pem, passphrase);
        }
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public String getFormat() {
        return this.format;
    }

    @Override
    public byte[] getEncoded() {
        return this.encoded;
    }
}

