/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.console;

import de.mhus.lib.core.console.Console;
import de.mhus.lib.core.console.ConsoleKey;
import de.mhus.lib.core.io.TextReader;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.LinkedList;

public class SimpleConsole
extends Console {
    private TextReader reader;
    private Console.COLOR foreground;
    private Console.COLOR background;
    private boolean blink;
    private boolean bold;
    protected int width = DEFAULT_WIDTH;
    protected int height = DEFAULT_HEIGHT;

    public SimpleConsole() {
        this.reader = new TextReader(System.in);
    }

    public SimpleConsole(InputStream in, PrintStream out, boolean flush, String charset) throws UnsupportedEncodingException {
        super(out, flush, charset);
        this.reader = new TextReader(in);
    }

    public SimpleConsole(InputStream in, PrintStream out) {
        super(out);
        this.reader = new TextReader(in);
    }

    @Override
    public String readLine(LinkedList<String> history) {
        return this.reader.readLine();
    }

    @Override
    public int read() {
        return this.reader.readChar();
    }

    @Override
    public ConsoleKey readKey() {
        int key = this.read();
        return new ConsoleKey(0, false, (char)key);
    }

    @Override
    public boolean isSupportSize() {
        return false;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public boolean isSupportCursor() {
        return false;
    }

    @Override
    public void setCursor(int x, int y) {
    }

    @Override
    public int getCursorX() {
        return -1;
    }

    @Override
    public int getCursorY() {
        return -1;
    }

    @Override
    public boolean isSupportColor() {
        return false;
    }

    @Override
    public void setColor(Console.COLOR foreground, Console.COLOR background) {
        this.foreground = foreground;
        this.background = background;
    }

    @Override
    public Console.COLOR getForegroundColor() {
        return this.foreground;
    }

    @Override
    public Console.COLOR getBackgroundColor() {
        return this.background;
    }

    @Override
    public boolean isSupportBlink() {
        return false;
    }

    @Override
    public void setBlink(boolean blink) {
        this.blink = blink;
    }

    @Override
    public boolean isBlink() {
        return this.blink;
    }

    @Override
    public boolean isSupportBold() {
        return false;
    }

    @Override
    public void setBold(boolean bold) {
        this.bold = bold;
    }

    @Override
    public boolean isBold() {
        return this.bold;
    }

    @Override
    public void cleanup() {
        this.bold = false;
        this.blink = false;
        this.foreground = Console.COLOR.WHITE;
        this.background = Console.COLOR.BLACK;
    }
}

