/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.console;

import de.mhus.lib.annotations.activator.DefaultImplementation;
import de.mhus.lib.core.M;
import de.mhus.lib.core.console.ConsoleFactory;
import de.mhus.lib.core.console.ConsoleKey;
import de.mhus.lib.core.console.ConsoleProgressBar;
import de.mhus.lib.core.console.SimpleConsole;
import de.mhus.lib.core.lang.Adaptable;
import de.mhus.lib.core.lang.IBase;
import de.mhus.lib.errors.NotSupportedException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.LinkedList;

@DefaultImplementation(value=SimpleConsole.class)
public abstract class Console
extends PrintStream
implements IBase,
Adaptable {
    public static int DEFAULT_WIDTH = 200;
    public static int DEFAULT_HEIGHT = 25;
    private static ThreadLocal<Console> consoles = new ThreadLocal();
    protected LinkedList<String> history = new LinkedList();

    public Console() {
        this(System.out);
    }

    public Console(PrintStream out) {
        super(out);
    }

    public Console(PrintStream out, boolean flush, String charset) throws UnsupportedEncodingException {
        super((OutputStream)out, flush, charset);
    }

    public static Console create() {
        Console console = consoles.get();
        if (console == null) {
            ConsoleFactory factory = M.l(ConsoleFactory.class);
            console = factory.create();
            consoles.set(console);
        }
        return console;
    }

    public String readLine() {
        return this.readLine(this.history);
    }

    public abstract String readLine(LinkedList<String> var1);

    public abstract int read();

    public abstract ConsoleKey readKey();

    public String readPassword() throws IOException {
        return new String(System.console().readPassword());
    }

    public void cr() {
        this.print('\r');
    }

    public abstract boolean isSupportSize();

    public abstract int getWidth();

    public abstract int getHeight();

    public abstract boolean isSupportCursor();

    public abstract void setCursor(int var1, int var2);

    public abstract int getCursorX();

    public abstract int getCursorY();

    public ConsoleProgressBar createProgressBar() {
        return new ConsoleProgressBar(this);
    }

    public abstract boolean isSupportColor();

    public abstract void setColor(COLOR var1, COLOR var2);

    public abstract COLOR getForegroundColor();

    public abstract COLOR getBackgroundColor();

    public abstract boolean isSupportBlink();

    public abstract void setBlink(boolean var1);

    public abstract boolean isBlink();

    public abstract boolean isSupportBold();

    public abstract void setBold(boolean var1);

    public abstract boolean isBold();

    public abstract void cleanup();

    public void printLine() {
        this.printLine('-');
    }

    public <T> T adaptTo(Class<? extends T> clazz) {
        if (clazz == OutputStream.class) {
            return (T)this;
        }
        if (clazz == InputStream.class) {
            return (T)new InputStream(){

                @Override
                public int read() throws IOException {
                    return Console.this.read();
                }
            };
        }
        throw new NotSupportedException(new Object[]{"Can't adapt to", clazz});
    }

    public void printLine(char c) {
        for (int i = 0; i < this.getWidth(); ++i) {
            this.print(c);
        }
        this.println();
    }

    public void resetTerminal() {
    }

    public static void resetConsole() {
        consoles.remove();
    }

    public static synchronized Console get() {
        Console console = consoles.get();
        if (console == null) {
            Console.create();
            console = consoles.get();
        }
        return console;
    }

    public static synchronized void set(Console console) {
        if (console == null) {
            consoles.remove();
        } else {
            consoles.set(console);
        }
    }

    public static boolean isInitialized() {
        Console console = consoles.get();
        return console != null;
    }

    public boolean isAnsi() {
        return false;
    }

    public void setWidth(int w) {
    }

    public void setHeight(int h) {
    }

    /*
     * Unable to fully structure code
     */
    public static char askQuestion(String question, char[] answers, boolean toLower, boolean acceptEnter) throws IOException {
        if (answers == null || answers.length == 0) {
            return '\u0000';
        }
        block0: while (true) {
            Console.get().print(question);
            Console.get().print(" (");
            first = true;
            for (char x : answers) {
                if (!first) {
                    Console.get().print('/');
                }
                Console.get().print(x);
                first = false;
            }
            Console.get().print(") ");
            Console.get().flush();
            key = Console.get().read();
            if (key < 0) {
                throw new IOException("Can't read from console");
            }
            Console.get().println((char)key);
            if (key == 13) {
                if (!acceptEnter) continue;
                return '\r';
            }
            c = (char)key;
            if (toLower) {
                c = Character.toLowerCase(c);
            }
            var7_9 = answers;
            var8_10 = var7_9.length;
            var9_11 = 0;
            while (true) {
                if (var9_11 < var8_10) ** break;
                continue block0;
                x = var7_9[var9_11];
                if (toLower) {
                    x = Character.toLowerCase(x);
                }
                if (c == x) {
                    return c;
                }
                ++var9_11;
            }
            break;
        }
    }

    public static enum COLOR {
        UNKNOWN,
        WHITE,
        BLACK,
        RED,
        GREEN,
        BLUE,
        YELLOW,
        MAGENTA,
        CYAN;

    }
}

