/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.config;

import de.mhus.lib.core.MFile;
import de.mhus.lib.core.config.PropertiesConfig;
import de.mhus.lib.errors.MException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class PropertiesConfigFile
extends PropertiesConfig {
    private static final long serialVersionUID = 1L;
    private File file;

    public PropertiesConfigFile(File file) throws IOException {
        if (file.exists()) {
            Reader reader = MFile.openFileReader(file, "UTF-8");
            this.properties.load(reader);
            reader.close();
        }
        this.file = file;
    }

    public PropertiesConfigFile(InputStream is) throws IOException {
        this(new InputStreamReader(is, "UTF-8"));
    }

    public PropertiesConfigFile(Reader reader) throws IOException {
        this.properties.load(reader);
        this.file = null;
    }

    public boolean canSave() {
        return this.file != null && this.file.canWrite();
    }

    public void save() throws MException {
        try {
            if (!this.canSave()) {
                return;
            }
            this.log().t("save config", this);
            FileOutputStream os = new FileOutputStream(this.file);
            this.properties.store(os, "");
            os.close();
        }
        catch (Exception e) {
            throw new MException(new Object[]{e});
        }
    }

    @Override
    public String toString() {
        return this.getClass() + ": " + (this.file == null ? "?" : this.file.getAbsolutePath());
    }

    public void setName(String name) {
        this.name = name;
    }

    public File getFile() {
        return this.file;
    }
}

