/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.concurrent;

import de.mhus.lib.core.M;
import de.mhus.lib.core.MCast;
import de.mhus.lib.core.base.service.LockManager;
import de.mhus.lib.core.concurrent.Lock;

public class LocalLock
implements Lock {
    protected Thread lock = null;
    protected String name;
    protected long lockTime = 0L;
    protected long cnt = 0L;
    protected String stacktrace;

    public LocalLock() {
    }

    public LocalLock(String name) {
        this.setName(name);
        this.register();
    }

    protected void register() {
        M.l(LockManager.class).register(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Lock lock() {
        LocalLock localLock = this;
        synchronized (localLock) {
            while (this.isLocked()) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.lock = Thread.currentThread();
            this.stacktrace = MCast.toString("", this.lock.getStackTrace());
            this.lockTime = System.currentTimeMillis();
            ++this.cnt;
            this.lockEvent(true);
        }
        return this;
    }

    protected void lockEvent(boolean locked) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean lock(long timeout) {
        LocalLock localLock = this;
        synchronized (localLock) {
            long start = System.currentTimeMillis();
            while (this.isLocked()) {
                try {
                    this.wait(timeout);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (System.currentTimeMillis() - start < timeout) continue;
                return false;
            }
            this.lock = Thread.currentThread();
            this.stacktrace = MCast.toString("", this.lock.getStackTrace());
            this.lockTime = System.currentTimeMillis();
            this.lockEvent(true);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean unlock() {
        LocalLock localLock = this;
        synchronized (localLock) {
            if (this.lock != Thread.currentThread()) {
                return false;
            }
            this.lockEvent(false);
            this.lock = null;
            this.stacktrace = null;
            this.lockTime = 0L;
            this.notify();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlockHard() {
        LocalLock localLock = this;
        synchronized (localLock) {
            this.lockEvent(false);
            this.lock = null;
            this.stacktrace = null;
            this.lockTime = 0L;
            this.notify();
        }
    }

    @Override
    public boolean isLocked() {
        return this.lock != null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getOwner() {
        return this.lock == null ? null : this.lock.getId() + " " + this.lock.toString();
    }

    public String toString() {
        return this.name + (String)(this.lock != null ? " " + this.lock.getName() : "");
    }

    @Override
    public long getLockTime() {
        return this.lockTime;
    }

    @Override
    public boolean refresh() {
        return this.isLocked();
    }

    @Override
    public long getCnt() {
        return this.cnt;
    }

    @Override
    public String getStartStackTrace() {
        return this.stacktrace;
    }
}

