/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.base.service;

import de.mhus.lib.core.MApi;
import de.mhus.lib.core.MFile;
import de.mhus.lib.core.MMath;
import de.mhus.lib.core.MProperties;
import de.mhus.lib.core.cfg.CfgBoolean;
import de.mhus.lib.core.cfg.CfgString;
import de.mhus.lib.core.lang.MObject;
import de.mhus.lib.core.parser.StringCompiler;
import java.io.File;
import java.io.IOException;
import java.util.UUID;

public class ServerIdent
extends MObject {
    private CfgString CFG_IDENT = new CfgString(ServerIdent.class, "ident", null){

        @Override
        protected void onPostUpdate(String newValue) {
            super.onPostUpdate(newValue);
            ServerIdent.this.update();
        }
    };
    private CfgString CFG_SERVICE = new CfgString(ServerIdent.class, "service", null){

        @Override
        protected void onPostUpdate(String newValue) {
            super.onPostUpdate(newValue);
            ServerIdent.this.update();
        }
    };
    private CfgString CFG_PATTERN = new CfgString(ServerIdent.class, "identPattern", "${#hostname}-${time}${random}"){

        @Override
        protected void onPostUpdate(String newValue) {
            super.onPostUpdate(newValue);
            ServerIdent.this.update();
        }
    };
    private CfgString CFG_SERVICE_PATTERN = new CfgString(ServerIdent.class, "servicePattern", "${#hostname}"){

        @Override
        protected void onPostUpdate(String newValue) {
            super.onPostUpdate(newValue);
            ServerIdent.this.update();
        }
    };
    private CfgBoolean CFG_PERSISTENT = new CfgBoolean((Object)ServerIdent.class, "persistent", true);
    private static MProperties ATTRIBUTES = new MProperties();
    private String ident = null;
    private String service = null;

    public ServerIdent() {
        this.update();
    }

    public static MProperties getAttributes() {
        return ATTRIBUTES;
    }

    private synchronized void update() {
        String def;
        if (this.CFG_IDENT == null || this.CFG_PATTERN == null || this.CFG_PERSISTENT == null || this.CFG_SERVICE == null || this.CFG_SERVICE_PATTERN == null) {
            return;
        }
        this.ident = (String)this.CFG_IDENT.value();
        String persistence = MApi.getFile(MApi.SCOPE.ETC, ServerIdent.class.getCanonicalName() + ".properties").getAbsolutePath();
        File file = new File(persistence);
        MProperties p = null;
        p = (Boolean)this.CFG_PERSISTENT.value() != false && file.exists() && file.isFile() ? MProperties.load(file) : new MProperties();
        if (this.ident == null) {
            def = p.getString("ident", null);
            if (def == null) {
                try {
                    def = StringCompiler.compile((String)this.CFG_PATTERN.value()).execute(ATTRIBUTES);
                    ATTRIBUTES.setString("default", def);
                    if (((Boolean)this.CFG_PERSISTENT.value()).booleanValue()) {
                        ATTRIBUTES.save(file);
                    }
                }
                catch (Exception e) {
                    this.log().e(e);
                }
            }
            this.ident = def = MFile.normalize(def);
            p.setString("ident", this.ident);
        }
        this.service = (String)this.CFG_SERVICE.value();
        if (this.service == null) {
            def = p.getString("service", null);
            if (def == null) {
                try {
                    def = StringCompiler.compile((String)this.CFG_SERVICE_PATTERN.value()).execute(ATTRIBUTES);
                    ATTRIBUTES.setString("default", def);
                    if (((Boolean)this.CFG_PERSISTENT.value()).booleanValue()) {
                        ATTRIBUTES.save(file);
                    }
                }
                catch (Exception e) {
                    this.log().e(e);
                }
            }
            this.service = def = MFile.normalize(def);
            p.setString("service", this.service);
        }
        if (((Boolean)this.CFG_PERSISTENT.value()).booleanValue() && file.exists() && file.isFile()) {
            try {
                p.save(file);
            }
            catch (IOException e) {
                this.log().w(file, e);
            }
        }
    }

    @Override
    public String toString() {
        return this.ident + "@" + this.service;
    }

    public String getIdent() {
        return this.ident;
    }

    public String getService() {
        return this.service;
    }

    static {
        ATTRIBUTES.setString("random", String.valueOf(MMath.toBasis36((long)(Math.random() * 36.0 * 36.0 * 36.0 * 36.0), 4)));
        ATTRIBUTES.setString("time", String.valueOf(MMath.toBasis36(System.currentTimeMillis(), 4)));
        ATTRIBUTES.setString("uuid", UUID.randomUUID().toString());
    }
}

