/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core;

import de.mhus.lib.core.MCast;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class MDate
extends Date {
    private static final long serialVersionUID = 1L;
    public static final Date NULL_DATE = new Date(0L);
    private static SimpleDateFormat iso8601DateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private static SimpleDateFormat fileDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
    private static SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm");
    private static SimpleDateFormat timeSecFormat = new SimpleDateFormat("HH:mm:ss");
    private static SimpleDateFormat germanDateFormat = new SimpleDateFormat("dd.MM.yyyy");
    private static SimpleDateFormat httpHeaderDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);

    public MDate() {
    }

    public MDate(long date) {
        super(date);
    }

    public MDate(Timestamp timestamp) {
        this(timestamp == null ? 0L : timestamp.getTime());
    }

    public MDate(String string) {
        Date date = MCast.toDate(string, null);
        if (date != null) {
            this.setTime(date.getTime());
        }
    }

    @Override
    public String toString() {
        return MDate.toIso8601(this);
    }

    public java.sql.Date toSqlDate() {
        return new java.sql.Date(this.getTime());
    }

    public Time toSqlTime() {
        return new Time(this.getTime());
    }

    public Timestamp toSqlTimestamp() {
        return new Timestamp(this.getTime());
    }

    public Calendar toCalendar() {
        return MCast.toCalendar(this);
    }

    public static boolean isEarlierAs(Date a, Date b) {
        return a.compareTo(b) < 0;
    }

    public static boolean isLaterAs(Date a, Date b) {
        return a.compareTo(b) > 0;
    }

    public static boolean isWorkDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int dayOfWeek = calendar.get(7);
        return dayOfWeek >= 2 && dayOfWeek <= 6;
    }

    public static boolean isWeekend(Date date) {
        return !MDate.isWorkDay(date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toIso8601(Date date) {
        SimpleDateFormat simpleDateFormat = iso8601DateFormat;
        synchronized (simpleDateFormat) {
            iso8601DateFormat.setTimeZone(TimeZone.getDefault());
            return iso8601DateFormat.format(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toIso8601(long timestamp) {
        SimpleDateFormat simpleDateFormat = iso8601DateFormat;
        synchronized (simpleDateFormat) {
            iso8601DateFormat.setTimeZone(TimeZone.getDefault());
            return iso8601DateFormat.format(new Date(timestamp));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toIso8601(Date date, TimeZone tz) {
        SimpleDateFormat simpleDateFormat = iso8601DateFormat;
        synchronized (simpleDateFormat) {
            iso8601DateFormat.setTimeZone(tz);
            return iso8601DateFormat.format(date);
        }
    }

    public static String toDateTimeString(Date date) {
        return MDate.toDateTimeString(date, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toDateTimeString(Date date, Locale locale) {
        DateFormat df = MDate.getLocaleDateFormatter(locale);
        SimpleDateFormat simpleDateFormat = timeFormat;
        synchronized (simpleDateFormat) {
            timeFormat.setTimeZone(TimeZone.getDefault());
            return df.format(date) + " " + timeFormat.format(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toDateTimeString(Date date, Locale locale, TimeZone tz) {
        DateFormat df = MDate.getLocaleDateFormatter(locale);
        SimpleDateFormat simpleDateFormat = timeFormat;
        synchronized (simpleDateFormat) {
            timeFormat.setTimeZone(tz);
            return df.format(date) + " " + timeFormat.format(date);
        }
    }

    public static String toDateTimeSecondsString(Date date) {
        return MDate.toDateTimeSecondsString(date, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toDateTimeSecondsString(Date date, Locale locale) {
        DateFormat df = MDate.getLocaleDateFormatter(locale);
        SimpleDateFormat simpleDateFormat = timeSecFormat;
        synchronized (simpleDateFormat) {
            timeSecFormat.setTimeZone(TimeZone.getDefault());
            return df.format(date) + " " + timeSecFormat.format(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toDateTimeSecondsString(Date date, Locale locale, TimeZone tz) {
        DateFormat df = MDate.getLocaleDateFormatter(locale);
        SimpleDateFormat simpleDateFormat = timeSecFormat;
        synchronized (simpleDateFormat) {
            timeSecFormat.setTimeZone(tz);
            return df.format(date) + " " + timeSecFormat.format(date);
        }
    }

    public static String toDateString(Date date) {
        return MDate.toDateString(date, null);
    }

    public static String toDateString(Date date, Locale locale) {
        DateFormat df = MDate.getLocaleDateFormatter(locale);
        return df.format(date);
    }

    public static DateFormat getLocaleDateFormatter(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (locale == null || Locale.GERMANY.equals(locale)) {
            return germanDateFormat;
        }
        int style = 3;
        return DateFormat.getDateInstance(style, locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toFileFormat(Date date) {
        SimpleDateFormat simpleDateFormat = fileDateFormat;
        synchronized (simpleDateFormat) {
            fileDateFormat.setTimeZone(TimeZone.getDefault());
            return fileDateFormat.format(date);
        }
    }

    public static String toIsoDate(Date _in) {
        Calendar c = Calendar.getInstance();
        c.setTime(_in);
        return MDate.toIsoDate(c);
    }

    public static String toIsoDateTime(Date _in) {
        Calendar c = Calendar.getInstance();
        c.setTime(_in);
        return MDate.toIsoDateTime(c);
    }

    public static String toIsoDateTime(Calendar _in) {
        return _in.get(1) + "-" + MCast.toString(_in.get(2) + 1, 2) + "-" + MCast.toString(_in.get(5), 2) + " " + MCast.toString(_in.get(11), 2) + ":" + MCast.toString(_in.get(12), 2) + ":" + MCast.toString(_in.get(13), 2);
    }

    public static String toIsoDateTime(long timeStamp) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(timeStamp);
        return MDate.toIsoDateTime(c);
    }

    public static String toIsoDate(Calendar _in) {
        return _in.get(1) + "-" + MCast.toString(_in.get(2) + 1, 2) + "-" + MCast.toString(_in.get(5), 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toIso8601(Calendar date) {
        SimpleDateFormat simpleDateFormat = iso8601DateFormat;
        synchronized (simpleDateFormat) {
            iso8601DateFormat.setTimeZone(TimeZone.getDefault());
            return iso8601DateFormat.format(date.getTime());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toIso8601(Calendar date, TimeZone tz) {
        SimpleDateFormat simpleDateFormat = iso8601DateFormat;
        synchronized (simpleDateFormat) {
            iso8601DateFormat.setTimeZone(tz);
            return iso8601DateFormat.format(date.getTime());
        }
    }

    public static String toFileFormat(Calendar date) {
        return fileDateFormat.format(date.getTime());
    }

    public static Date toDate(Object in, Date def, Locale locale) {
        return MCast.toDate(in, def, locale);
    }

    public static Date toDate(Object in, Date def) {
        return MCast.toDate(in, def);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toTimeString(Date date) {
        SimpleDateFormat simpleDateFormat = timeFormat;
        synchronized (simpleDateFormat) {
            timeFormat.setTimeZone(TimeZone.getDefault());
            return timeFormat.format(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toTimeString(Date date, TimeZone tz) {
        SimpleDateFormat simpleDateFormat = timeFormat;
        synchronized (simpleDateFormat) {
            timeFormat.setTimeZone(tz);
            return timeFormat.format(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toTimeSecondsString(Date date) {
        SimpleDateFormat simpleDateFormat = timeSecFormat;
        synchronized (simpleDateFormat) {
            timeSecFormat.setTimeZone(TimeZone.getDefault());
            return timeSecFormat.format(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toTimeSecondsString(Date date, TimeZone tz) {
        SimpleDateFormat simpleDateFormat = timeSecFormat;
        synchronized (simpleDateFormat) {
            timeSecFormat.setTimeZone(tz);
            return timeSecFormat.format(date);
        }
    }

    public static String toString(String format, Date date) {
        return new SimpleDateFormat(format).format(date);
    }

    public static String transform(String format, String date, Date def) {
        Date d = MDate.toDate(date, def);
        if (d == null) {
            return null;
        }
        return MDate.toString(format, d);
    }

    public static Date toDateOnly(Date date) {
        if (date == null) {
            return null;
        }
        return new Date(date.getTime() / 86400000L * 86400000L);
    }

    public static int lastDayOfMonth(int month, int year) {
        Calendar cal = Calendar.getInstance();
        cal.set(2, month);
        cal.set(1, year);
        cal.set(5, 1);
        cal.add(2, 1);
        cal.add(5, -1);
        int lastDay = cal.get(5);
        return lastDay;
    }

    public static String toHttpHeaderDate(long date) {
        return MDate.toHttpHeaderDate(new Date(date));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toHttpHeaderDate(Date date) {
        SimpleDateFormat simpleDateFormat = httpHeaderDateFormat;
        synchronized (simpleDateFormat) {
            return httpHeaderDateFormat.format(date);
        }
    }

    static {
        httpHeaderDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

