/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.LinkedList;

public class MBigMath {
    public static final char[] BASE_62_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    public static final char[] BASE_91_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00b1', '\u00a7', '!', '@', '#', '$', '%', '^', '&', '*', '(', ')', '_', '+', '=', '{', '[', '}', ']', ';', '|', '~', '`', '<', ',', '>', '.', '?', '/'};
    public static final BigInteger TWO = BigInteger.valueOf(2L);
    public static final BigInteger SIXTY_TWO = BigInteger.valueOf(62L);
    public static final BigInteger NINE_ONE = BigInteger.valueOf(91L);
    public static final BigDecimal BD_MINUS_ONE = BigDecimal.valueOf(-1L);
    public static final BigDecimal BD_TWO = BigDecimal.valueOf(2L);
    public static final BigDecimal BD_TEN = BigDecimal.valueOf(10L);
    public static final BigDecimal BD_ONE_HUNDRED = BigDecimal.valueOf(100L);
    private static final BigDecimal SQRT_DIG = new BigDecimal(150);
    private static final BigDecimal SQRT_PRE = new BigDecimal(10).pow(SQRT_DIG.intValue());

    public static BigInteger binaryPow(BigInteger base, BigInteger pow, BigInteger mod) throws IOException {
        if (mod.subtract(BigInteger.ONE).pow(2).compareTo(base) > 1) {
            throw new IOException("modulo is too big");
        }
        BigInteger res = BigInteger.ONE;
        base = base.mod(mod);
        while (pow.compareTo(BigInteger.ZERO) == 1) {
            if (pow.mod(TWO).equals(BigInteger.ONE)) {
                res = res.multiply(base).mod(mod);
            }
            pow = pow.shiftRight(1);
            base = base.multiply(base).mod(mod);
        }
        return res;
    }

    public static BigInteger dividePow(BigInteger base, BigInteger pow, BigInteger mod) {
        return MBigMath.dividePow(base, pow, 1L).mod(mod);
    }

    private static BigInteger dividePow(BigInteger base, BigInteger pow, long level) {
        boolean odd = false;
        if (pow.mod(TWO).equals(BigInteger.ONE)) {
            pow = pow.subtract(BigInteger.ONE);
            odd = true;
        }
        BigInteger half = pow.divide(TWO);
        BigInteger res = null;
        if (half.equals(BigInteger.ONE)) {
            res = base.multiply(base);
        } else {
            res = MBigMath.dividePow(base, half, level + 1L);
            res = res.multiply(res);
        }
        if (odd) {
            res = res.multiply(base);
        }
        return res;
    }

    public static BigInteger straightPow(BigInteger base, BigInteger pow, BigInteger mod) {
        BigInteger res = base;
        BigInteger bi = BigInteger.ONE;
        while (bi.compareTo(pow) == -1) {
            res = res.multiply(base);
            bi = bi.add(BigInteger.ONE);
        }
        return res.mod(mod);
    }

    public static BigInteger splitPow(BigInteger base, BigInteger pow, BigInteger mod) {
        BigInteger res = base;
        BigInteger bi = BigInteger.ONE;
        while (bi.compareTo(pow) == -1) {
            res = res.multiply(base).mod(mod);
            bi = bi.add(BigInteger.ONE);
        }
        return res.mod(mod);
    }

    public static BigDecimal log10(BigDecimal b, int dp) {
        int NUM_OF_DIGITS = dp + 2;
        MathContext mc = new MathContext(NUM_OF_DIGITS, RoundingMode.HALF_EVEN);
        if (b.signum() <= 0) {
            throw new ArithmeticException("log of a negative number! (or zero)");
        }
        if (b.compareTo(BigDecimal.ONE) == 0) {
            return BigDecimal.ZERO;
        }
        if (b.compareTo(BigDecimal.ONE) < 0) {
            return MBigMath.log10(BigDecimal.ONE.divide(b, mc), dp).negate();
        }
        StringBuilder sb = new StringBuilder();
        int leftDigits = b.precision() - b.scale();
        sb.append(leftDigits - 1).append(".");
        for (int n = 0; n < NUM_OF_DIGITS; ++n) {
            b = b.movePointLeft(leftDigits - 1).pow(10, mc);
            leftDigits = b.precision() - b.scale();
            sb.append(leftDigits - 1);
        }
        BigDecimal ans = new BigDecimal(sb.toString());
        ans = ans.round(new MathContext(ans.precision() - ans.scale() + dp, RoundingMode.HALF_EVEN));
        return ans;
    }

    public static BigInteger computeDfromE(BigInteger e, BigInteger z) {
        BigDecimal E = new BigDecimal(e);
        BigDecimal Z = new BigDecimal(z);
        BigDecimal D = new BigDecimal(1);
        BigDecimal T = null;
        while ((T = (D = D.add(Z)).divide(E, 100, RoundingMode.UP).stripTrailingZeros()).scale() > 0) {
        }
        return T.toBigInteger();
    }

    public static BigDecimal sqrt(BigDecimal x, int scale) {
        BigInteger ixPrev;
        if (x.signum() < 0) {
            throw new IllegalArgumentException("x < 0");
        }
        BigInteger n = x.movePointRight(scale << 1).toBigInteger();
        int bits = n.bitLength() + 1 >> 1;
        BigInteger ix = n.shiftRight(bits);
        do {
            ixPrev = ix;
            ix = ix.add(n.divide(ix)).shiftRight(1);
            Thread.yield();
        } while (ix.compareTo(ixPrev) != 0);
        return new BigDecimal(ix, scale);
    }

    private static BigDecimal sqrtNewtonRaphson(BigDecimal c, BigDecimal xn, BigDecimal precision) {
        BigDecimal fx = xn.pow(2).add(c.negate());
        BigDecimal fpx = xn.multiply(new BigDecimal(2));
        BigDecimal xn1 = fx.divide(fpx, 2 * SQRT_DIG.intValue(), RoundingMode.DOWN);
        xn1 = xn.add(xn1.negate());
        BigDecimal currentSquare = xn1.pow(2);
        BigDecimal currentPrecision = currentSquare.subtract(c);
        if ((currentPrecision = currentPrecision.abs()).compareTo(precision) <= -1) {
            return xn1;
        }
        return MBigMath.sqrtNewtonRaphson(c, xn1, precision);
    }

    public static BigDecimal bigSqrt(BigDecimal c) {
        return MBigMath.sqrtNewtonRaphson(c, new BigDecimal(1), new BigDecimal(1).divide(SQRT_PRE));
    }

    public static String toBase62(BigInteger in) {
        StringBuilder out = new StringBuilder();
        boolean negative = false;
        if (in.signum() == 0) {
            return "0";
        }
        if (in.signum() == -1) {
            negative = true;
            in = in.negate();
        }
        while (in.signum() != 0) {
            int m = in.mod(SIXTY_TWO).intValue();
            out.insert(0, BASE_62_CHARS[m]);
            in = in.divide(SIXTY_TWO);
        }
        if (negative) {
            out.insert(0, '-');
        }
        return out.toString();
    }

    public static BigInteger fromBase62(String in) {
        return MBigMath.fromBase62(in, false);
    }

    public static BigInteger fromBase62(String in, boolean ignoreWhitespace) {
        BigInteger out = BigInteger.ZERO;
        in = in.trim();
        boolean negative = false;
        if (in.startsWith("-")) {
            negative = true;
            in = in.substring(1);
        }
        for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            int m = 0;
            if (c >= '0' && c <= '9') {
                m = c - 48;
            } else if (c >= 'a' && c <= 'z') {
                m = c - 97 + 10;
            } else if (c >= 'A' && c <= 'Z') {
                m = c - 65 + 36;
            } else {
                if (!ignoreWhitespace || c != '\n' && c != '\r' && c != '\t' && c != ' ') break;
                continue;
            }
            out = out.multiply(SIXTY_TWO).add(BigInteger.valueOf(m));
        }
        if (negative) {
            out = out.negate();
        }
        return out;
    }

    public static String toBase62(BigInteger[] in) {
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < in.length; ++i) {
            if (i != 0) {
                out.append(':');
            }
            out.append(MBigMath.toBase62(in[i]));
        }
        return out.toString();
    }

    public static BigInteger[] fromBase62Array(String in) {
        LinkedList<BigInteger> out = new LinkedList<BigInteger>();
        while (true) {
            BigInteger n = MBigMath.fromBase62(in, true);
            out.add(n);
            int pos = in.indexOf(58);
            if (pos < 0) break;
            in = in.substring(pos + 1);
        }
        return out.toArray(new BigInteger[out.size()]);
    }

    public static String toBase91(BigInteger in) {
        StringBuilder out = new StringBuilder();
        boolean negative = false;
        if (in.signum() == 0) {
            return "0";
        }
        if (in.signum() == -1) {
            negative = true;
            in = in.negate();
        }
        while (in.signum() != 0) {
            int m = in.mod(NINE_ONE).intValue();
            out.insert(0, BASE_91_CHARS[m]);
            in = in.divide(NINE_ONE);
        }
        if (negative) {
            out.insert(0, '-');
        }
        return out.toString();
    }

    public static BigInteger fromBase91(String in) {
        return MBigMath.fromBase91(in, false);
    }

    public static BigInteger fromBase91(String in, boolean ignoreWhitespace) {
        BigInteger out = BigInteger.ZERO;
        in = in.trim();
        boolean negative = false;
        if (in.startsWith("-")) {
            negative = true;
            in = in.substring(1);
        }
        for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            int m = 0;
            if (c >= '0' && c <= '9') {
                m = c - 48;
            } else if (c >= 'a' && c <= 'z') {
                m = c - 97 + 10;
            } else if (c >= 'A' && c <= 'Z') {
                m = c - 65 + 36;
            } else if (c == '\u00b1') {
                m = 62;
            } else if (c == '\u00a7') {
                m = 63;
            } else if (c == '!') {
                m = 64;
            } else if (c == '@') {
                m = 65;
            } else if (c == '#') {
                m = 66;
            } else if (c == '$') {
                m = 67;
            } else if (c == '%') {
                m = 68;
            } else if (c == '^') {
                m = 69;
            } else if (c == '&') {
                m = 70;
            } else if (c == '*') {
                m = 71;
            } else if (c == '(') {
                m = 72;
            } else if (c == ')') {
                m = 73;
            } else if (c == '_') {
                m = 74;
            } else if (c == '+') {
                m = 75;
            } else if (c == '=') {
                m = 76;
            } else if (c == '{') {
                m = 77;
            } else if (c == '[') {
                m = 78;
            } else if (c == '}') {
                m = 79;
            } else if (c == ']') {
                m = 80;
            } else if (c == ';') {
                m = 81;
            } else if (c == '|') {
                m = 82;
            } else if (c == '~') {
                m = 83;
            } else if (c == '`') {
                m = 84;
            } else if (c == '<') {
                m = 85;
            } else if (c == ',') {
                m = 86;
            } else if (c == '>') {
                m = 87;
            } else if (c == '.') {
                m = 88;
            } else if (c == '?') {
                m = 89;
            } else if (c == '/') {
                m = 90;
            } else {
                if (!ignoreWhitespace || c != '\n' && c != '\r' && c != '\t' && c != ' ') break;
                continue;
            }
            out = out.multiply(NINE_ONE).add(BigInteger.valueOf(m));
        }
        if (negative) {
            out = out.negate();
        }
        return out;
    }

    public static String toBase91(BigInteger[] in) {
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < in.length; ++i) {
            if (i != 0) {
                out.append(':');
            }
            out.append(MBigMath.toBase91(in[i]));
        }
        return out.toString();
    }

    public static BigInteger[] fromBase91Array(String in) {
        LinkedList<BigInteger> out = new LinkedList<BigInteger>();
        while (true) {
            BigInteger n = MBigMath.fromBase91(in, true);
            out.add(n);
            int pos = in.indexOf(58);
            if (pos < 0) break;
            in = in.substring(pos + 1);
        }
        return out.toArray(new BigInteger[out.size()]);
    }

    public static BigDecimal min(BigDecimal a, BigDecimal b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return a.compareTo(b) > 0 ? b : a;
    }

    public static BigDecimal max(BigDecimal a, BigDecimal b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return a.compareTo(b) > 0 ? a : b;
    }
}

