/**
 * Copyright 2018 Mike Hummel
 *
 * <p>Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of the License at
 *
 * <p>http://www.apache.org/licenses/LICENSE-2.0
 *
 * <p>Unless required by applicable law or agreed to in writing, software distributed under the
 * License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing permissions and
 * limitations under the License.
 */
package de.mhus.lib.core.util;

import java.util.Iterator;

public class IteratorCast<F, T> implements Iterator<T> {

    private Iterator<F> from;

    public IteratorCast(Iterator<F> from) {
        this.from = from;
    }

    @Override
    public boolean hasNext() {
        return from.hasNext();
    }

    @SuppressWarnings("unchecked")
    @Override
    public T next() {
        return (T) from.next();
    }

    @Override
    public void remove() {
        from.remove();
    }
}
