/**
 * Copyright 2018 Mike Hummel
 *
 * <p>Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of the License at
 *
 * <p>http://www.apache.org/licenses/LICENSE-2.0
 *
 * <p>Unless required by applicable law or agreed to in writing, software distributed under the
 * License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing permissions and
 * limitations under the License.
 */
package de.mhus.lib.core.parser;

import java.io.IOException;

import de.mhus.lib.core.lang.MObject;

public abstract class StringParsingPart extends MObject implements ParsingPart {

    @Override
    public void parse(ParseReader str) throws ParseException {
        doPreParse();

        try {
            while (!str.isClosed()) {
                char c = str.character();
                boolean res = parse(c, str);
                if (!res) {
                    doPostParse();
                    return;
                }
            }
        } catch (IOException e) {
            throw new ParseException(e);
        }

        doPostParse();
    }

    public abstract void doPreParse();

    public abstract void doPostParse();

    public abstract boolean parse(char c, ParseReader str) throws ParseException, IOException;
}
