/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.vault;

import de.mhus.lib.core.M;
import de.mhus.lib.core.MJson;
import de.mhus.lib.core.MSystem;
import de.mhus.lib.core.util.SecureString;
import de.mhus.lib.core.vault.MapMutableVaultSource;
import de.mhus.lib.core.vault.MutableVaultSource;
import de.mhus.lib.core.vault.VaultEntry;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;

public class VaultSourceFromPlainJson
extends MapMutableVaultSource {
    private boolean editable;
    private File file;
    private long fileModified;
    private boolean fileCanWrite;

    public VaultSourceFromPlainJson(File file, boolean editable, String name) throws IOException {
        this.file = file;
        this.name = name;
        this.editable = editable;
        if (file.exists()) {
            this.doLoad();
        }
    }

    @Override
    public void doLoad() throws IOException {
        this.entries.clear();
        JsonNode json = MJson.load(this.file);
        for (JsonNode jEntry : json) {
            PlainEntry entry = new PlainEntry(jEntry);
            this.entries.put(entry.getId(), entry);
        }
        this.fileModified = this.file.lastModified();
        this.fileCanWrite = this.file.canWrite();
    }

    @Override
    public void doSave() throws IOException {
        ArrayNode json = MJson.createArrayNode();
        for (VaultEntry entry : this.entries.values()) {
            ObjectNode jEntry = MJson.createObjectNode();
            json.add((JsonNode)jEntry);
            jEntry.put("id", entry.getId().toString());
            jEntry.put("value", entry.getValue().value());
            jEntry.put("name", entry.getName());
            jEntry.put("type", entry.getType());
            jEntry.put("desc", entry.getDescription());
        }
        MJson.save((JsonNode)json, this.file);
        this.fileModified = this.file.lastModified();
    }

    @Override
    public boolean isMemoryBased() {
        return true;
    }

    @Override
    public MutableVaultSource getEditable() {
        if (!this.editable || !this.fileCanWrite) {
            return null;
        }
        return this;
    }

    @Override
    public String toString() {
        return MSystem.toString(this, this.name, this.entries.size(), this.file);
    }

    @Override
    protected void doCheckSource() {
        if (this.file.lastModified() != this.fileModified) {
            try {
                this.doLoad();
            }
            catch (IOException e) {
                this.log().e(this.file, e);
            }
        }
    }

    private class PlainEntry
    implements VaultEntry {
        private UUID id;
        private SecureString value;
        private String type;
        private String name;
        private String desc;

        public PlainEntry(JsonNode node) {
            this.id = UUID.fromString(node.get("id").asText());
            this.value = new SecureString(node.get("value").asText());
            this.name = M.get(node, "name", null);
            this.type = M.get(node, "type", null);
            this.desc = M.get(node, "desc", null);
        }

        @Override
        public UUID getId() {
            return this.id;
        }

        @Override
        public String getType() {
            return this.type;
        }

        @Override
        public String getDescription() {
            return this.desc;
        }

        @Override
        public SecureString getValue() {
            return this.value;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

