/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.vault;

import de.mhus.lib.core.crypt.pem.PemBlock;
import de.mhus.lib.core.crypt.pem.PemUtil;
import de.mhus.lib.core.parser.ParseException;
import de.mhus.lib.core.util.SecureString;
import de.mhus.lib.core.vault.DefaultEntry;
import java.util.UUID;

public class PemEntry
extends DefaultEntry {
    public PemEntry(String entry) throws ParseException {
        this(PemUtil.parse(entry));
    }

    public PemEntry(PemBlock block) {
        String str = block.getString("Ident", null);
        this.id = str == null ? UUID.randomUUID() : UUID.fromString(str);
        this.description = block.getString("Description", "");
        String method = block.getString("Method", "").toUpperCase();
        this.type = PemUtil.isPubKey(block) ? (method.contains("RSA") ? "rsa.cipher.public.key" : (method.contains("DSA") ? "dsa.sign.public.key" : (method.contains("ECC") ? "ecc.sign.public.key" : "?.cipher.public.key"))) : (PemUtil.isPrivKey(block) ? (method.contains("RSA") ? "rsa.cipher.private.key" : (method.contains("DSA") ? "dsa.sign.private.key" : (method.contains("ECC") ? "ecc.sign.private.key" : "?.cipher.private.key"))) : "text");
        this.value = new SecureString(block.toString());
    }
}

