/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.vault;

import de.mhus.lib.core.M;
import de.mhus.lib.core.MArgs;
import de.mhus.lib.core.console.ConsoleTable;
import de.mhus.lib.core.parser.ParseException;
import de.mhus.lib.core.vault.MVault;
import de.mhus.lib.core.vault.VaultEntry;
import de.mhus.lib.core.vault.VaultMutator;
import de.mhus.lib.core.vault.VaultPassphrase;
import de.mhus.lib.core.vault.VaultSource;
import de.mhus.lib.core.vault.VaultSourceFactory;
import de.mhus.lib.core.vault.VaultSourceFromSecFile;
import de.mhus.lib.errors.NotSupportedException;
import java.io.File;
import java.io.IOException;
import java.util.UUID;

public class MVaultUtil {
    public static MVault loadDefault() {
        MVault vault = M.l(MVault.class);
        MVaultUtil.checkDefault(vault);
        return vault;
    }

    public static void checkDefault(MVault vault) {
        VaultSource def = vault.getSource("default");
        if (def == null) {
            VaultPassphrase vaultPassphrase = M.l(VaultPassphrase.class);
            VaultSourceFactory factory = M.l(VaultSourceFactory.class);
            def = factory.create("default", vaultPassphrase);
            if (def != null) {
                vault.registerSource(def);
            }
        }
    }

    public static void main(String[] in) throws IOException {
        String cmd;
        MArgs args = new MArgs(in);
        MVault vault = MVaultUtil.loadDefault();
        VaultSource source = null;
        if (args.contains("file")) {
            String vp = args.getValue("passphrase", "setit", 0);
            File f = new File(args.getValue("file", 0));
            source = new VaultSourceFromSecFile(f, vp);
            vault.registerSource(source);
        }
        if (source == null) {
            source = vault.getSource("default");
        }
        switch (cmd = args.getValue("", "help", 0)) {
            case "help": {
                System.out.println("Usage: <cmd> <args>");
                System.out.println("list - list all keys");
                break;
            }
            case "list": {
                ConsoleTable out = new ConsoleTable();
                out.setHeaderValues("Source", "Id", "Type", "Description");
                for (String sourceName : vault.getSourceNames()) {
                    source = vault.getSource(sourceName);
                    for (UUID id : source.getEntryIds()) {
                        VaultEntry entry = source.getEntry(id);
                        out.addRowValues(sourceName, id, entry.getType(), entry.getDescription());
                    }
                }
                out.print(System.out);
            }
        }
    }

    public static <T> T adaptTo(VaultEntry entry, Class<? extends T> ifc) throws ParseException, NotSupportedException {
        return M.l(VaultMutator.class).adaptTo(entry, ifc);
    }

    public static String getType(String content) {
        if (content.contains("-----BEGIN RSA PRIVATE KEY-----")) {
            return "rsa.cipher.private.key";
        }
        if (content.contains("-----BEGIN RSA PUBLIC KEY-----")) {
            return "rsa.cipher.public.key";
        }
        if (content.contains("-----BEGIN DSA PRIVATE KEY-----")) {
            return "dsa.sign.private.key";
        }
        if (content.contains("-----BEGIN DSA PUBLIC KEY-----")) {
            return "dsa.sign.public.key";
        }
        if (content.contains("-----BEGIN ECC PRIVATE KEY-----")) {
            return "ecc.sign.private.key";
        }
        if (content.contains("-----BEGIN ECC PUBLIC KEY-----")) {
            return "ecc.sign.public.key";
        }
        return "text";
    }
}

