/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.vault;

import de.mhus.lib.core.MSystem;
import de.mhus.lib.core.util.SecureString;
import de.mhus.lib.core.vault.VaultEntry;
import java.util.UUID;

public class DefaultEntry
implements VaultEntry {
    protected UUID id = UUID.randomUUID();
    protected String type;
    protected String description;
    protected SecureString value;
    private String name;

    public DefaultEntry() {
    }

    public DefaultEntry(UUID id, String type, String name, String description, String value) {
        this(type, name, description, value);
        this.id = id;
    }

    public DefaultEntry(UUID id, String type, String name, String description, SecureString value) {
        this(type, name, description, value);
        this.id = id;
    }

    public DefaultEntry(String type, String name, String description, String value) {
        this.type = type;
        this.name = name;
        this.description = description;
        this.value = new SecureString(value);
    }

    public DefaultEntry(String type, String name, String description, SecureString value) {
        this.type = type;
        this.name = name;
        this.description = description;
        this.value = value;
    }

    public DefaultEntry(VaultEntry clone) {
        this(clone.getId(), clone.getType(), clone.getName(), clone.getDescription(), clone.getValue());
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public SecureString getValue() {
        return this.value;
    }

    public String toString() {
        return MSystem.toString(this, this.id, this.type);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

