/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.util;

import de.mhus.lib.core.AbstractProperties;
import de.mhus.lib.core.IProperties;
import de.mhus.lib.core.util.MapEntry;
import de.mhus.lib.errors.NotSupportedException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PropertiesSubset
extends AbstractProperties {
    private static final long serialVersionUID = 1L;
    private IProperties parent;
    private String prefix;
    private boolean readonly;
    private int len;

    public PropertiesSubset(IProperties parent, String prefix) {
        this(parent, prefix, false);
        this.len = prefix.length();
    }

    public PropertiesSubset(IProperties parent, String prefix, boolean readonly) {
        this.parent = parent;
        this.prefix = prefix;
        this.readonly = readonly;
    }

    @Override
    public Object getProperty(String name) {
        return this.parent.get(this.prefix + name);
    }

    @Override
    public boolean isProperty(String name) {
        return this.parent.isProperty(this.prefix + name);
    }

    @Override
    public void removeProperty(String key) {
        if (this.readonly) {
            throw new NotSupportedException(new Object[0]);
        }
        this.parent.removeProperty(this.prefix + key);
    }

    @Override
    public void setProperty(String key, Object value) {
        if (this.readonly) {
            throw new NotSupportedException(new Object[0]);
        }
        this.parent.put(this.prefix + key, value);
    }

    @Override
    public boolean isEditable() {
        if (this.readonly) {
            return false;
        }
        return this.parent.isEditable();
    }

    @Override
    public Set<String> keys() {
        HashSet<String> out = new HashSet<String>();
        for (String k : this.parent.keys()) {
            if (!k.startsWith(this.prefix)) continue;
            out.add(k);
        }
        return out;
    }

    @Override
    public int size() {
        int cnt = 0;
        for (String k : this.parent.keys()) {
            if (!k.startsWith(this.prefix)) continue;
            ++cnt;
        }
        return cnt;
    }

    @Override
    public boolean containsValue(Object value) {
        for (Map.Entry<String, Object> entry : this.parent.entrySet()) {
            if (!entry.getKey().startsWith(this.prefix) || !value.equals(entry.getValue())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<Object> values() {
        HashSet<Object> out = new HashSet<Object>();
        for (Map.Entry<String, Object> entry : this.parent.entrySet()) {
            if (!entry.getKey().startsWith(this.prefix)) continue;
            out.add(entry.getValue());
        }
        return out;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        HashSet<Map.Entry<String, Object>> out = new HashSet<Map.Entry<String, Object>>();
        for (Map.Entry<String, Object> entry : this.parent.entrySet()) {
            if (!entry.getKey().startsWith(this.prefix)) continue;
            out.add(new MapEntry<String, Object>(entry.getKey().substring(this.len), entry.getValue()));
        }
        return out;
    }

    @Override
    public void clear() {
        for (String key : this.keys()) {
            this.remove(key);
        }
    }

    @Override
    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append(this.prefix).append("=[");
        boolean first = true;
        for (String k : this.parent.keys()) {
            if (!k.startsWith(this.prefix)) continue;
            if (first) {
                first = false;
            } else {
                out.append(", ");
            }
            out.append(k.substring(this.len)).append('=').append(this.parent.get(k));
        }
        out.append(']');
        return out.toString();
    }
}

