/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.util;

import de.mhus.lib.core.IProperties;
import de.mhus.lib.core.MCast;
import de.mhus.lib.core.MProperties;
import de.mhus.lib.core.MString;
import de.mhus.lib.core.util.EmptySet;
import de.mhus.lib.core.util.MUri;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class FilterRequest {
    private Map<String, String> facets;
    private String[] text;

    public FilterRequest(String[] text, Map<String, String> facets) {
        this.text = text;
        this.facets = facets;
    }

    public FilterRequest(String text) {
        if (text == null) {
            return;
        }
        LinkedList<String> lText = new LinkedList<String>();
        this.facets = new HashMap<String, String>();
        for (String part : text.split(" ")) {
            int p;
            if (!MString.isSet(part = part.trim())) continue;
            if (part.startsWith("'") && part.endsWith("'") && part.length() > 1) {
                part = MUri.decode(part.substring(1, part.length() - 1));
            }
            if ((p = part.indexOf(58)) > 0) {
                this.facets.put(part.substring(0, p), part.substring(p + 1));
                continue;
            }
            lText.add(part);
        }
        this.text = lText.toArray(new String[lText.size()]);
    }

    public String[] getText() {
        if (this.text == null) {
            return new String[0];
        }
        return this.text;
    }

    public boolean isFiltering() {
        return this.text != null && this.text.length > 0 || this.facets != null && this.facets.size() > 0;
    }

    public String getFacet(String name) {
        if (this.facets == null) {
            return null;
        }
        return this.facets.get(name);
    }

    public Date getFacet(String name, Date def) {
        if (this.facets == null) {
            return def;
        }
        return MCast.toDate(this.facets.get(name), def);
    }

    public int getFacet(String name, int def) {
        if (this.facets == null) {
            return def;
        }
        return MCast.toint(this.facets.get(name), def);
    }

    public long getFacet(String name, long def) {
        if (this.facets == null) {
            return def;
        }
        return MCast.tolong(this.facets.get(name), def);
    }

    public boolean getFacet(String name, boolean def) {
        if (this.facets == null) {
            return def;
        }
        return MCast.toboolean(this.facets.get(name), def);
    }

    public Set<String> getFacetKeys() {
        if (this.facets == null) {
            return new EmptySet<String>();
        }
        return this.facets.keySet();
    }

    public IProperties toProperties() {
        return new MProperties(this.facets);
    }

    public boolean isText() {
        return this.text != null && this.text.length > 0;
    }

    public boolean isFacet(String key) {
        return this.facets != null && this.facets.containsKey(key);
    }
}

