/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.system;

import de.mhus.lib.core.logging.Log;
import de.mhus.lib.core.logging.StreamToLogAdapter;
import java.io.PrintStream;

public class SecureStreamToLogAdapter
extends StreamToLogAdapter {
    protected static ThreadLocal<Boolean> enter = new ThreadLocal();

    public SecureStreamToLogAdapter(Log.LEVEL level, PrintStream forward) {
        super(level, forward);
    }

    @Override
    protected void writeLine() {
        if (enter.get() != null) {
            return;
        }
        enter.set(true);
        try {
            log.log(this.level, this.line);
            this.line.setLength(0);
        }
        finally {
            enter.remove();
        }
    }
}

