/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.system;

import de.mhus.lib.core.M;
import de.mhus.lib.core.MActivator;
import de.mhus.lib.core.MApi;
import de.mhus.lib.core.MFile;
import de.mhus.lib.core.MSystem;
import de.mhus.lib.core.activator.DefaultActivator;
import de.mhus.lib.core.lang.Base;
import de.mhus.lib.core.lang.BaseControl;
import de.mhus.lib.core.logging.ConsoleFactory;
import de.mhus.lib.core.logging.Log;
import de.mhus.lib.core.logging.LogFactory;
import de.mhus.lib.core.logging.MLogFactory;
import de.mhus.lib.core.system.ApiInitialize;
import de.mhus.lib.core.system.CfgManager;
import de.mhus.lib.core.system.IApi;
import de.mhus.lib.core.system.IApiInternal;
import java.io.File;
import java.util.HashSet;
import java.util.Set;

public class DefaultMApi
implements IApi,
ApiInitialize,
IApiInternal {
    private LogFactory logFactory = new ConsoleFactory();
    private BaseControl baseControl;
    private CfgManager configProvider;
    private HashSet<String> logTrace = new HashSet();
    private File baseDir = new File(".");
    private MLogFactory mlogFactory;

    @Override
    public void doInitialize(ClassLoader coreLoader) {
        this.getCfgManager().reConfigure();
    }

    @Override
    public synchronized BaseControl getBaseControl() {
        if (this.baseControl == null) {
            this.baseControl = new BaseControl();
        }
        return this.baseControl;
    }

    @Override
    public MActivator createActivator() {
        return new DefaultActivator();
    }

    @Override
    public LogFactory getLogFactory() {
        return this.logFactory;
    }

    @Override
    public synchronized CfgManager getCfgManager() {
        if (this.configProvider == null) {
            this.configProvider = new CfgManager(this);
        }
        return this.configProvider;
    }

    @Override
    public boolean isTrace(String name) {
        return this.logTrace.contains(name);
    }

    @Override
    public Base base() {
        return this.getBaseControl().base();
    }

    @Override
    public void setLogFactory(LogFactory logFactory) {
        this.logFactory = logFactory;
    }

    @Override
    public Set<String> getLogTrace() {
        return this.logTrace;
    }

    @Override
    public void setBaseDir(File file) {
        this.baseDir = file;
        this.baseDir.mkdirs();
    }

    @Override
    public File getFile(MApi.SCOPE scope, String dir) {
        File log;
        dir = MFile.normalizePath(dir);
        if (scope == MApi.SCOPE.TMP) {
            return new File(MSystem.getTmpDirectory() + File.pathSeparator + dir);
        }
        if (scope == MApi.SCOPE.LOG && (log = new File(this.baseDir, "logs")).exists() && log.isDirectory()) {
            return new File(log, dir);
        }
        return new File(this.baseDir, dir);
    }

    @Override
    public synchronized Log lookupLog(Object owner) {
        if (this.mlogFactory == null) {
            this.mlogFactory = M.l(MLogFactory.class);
        }
        return this.mlogFactory.lookup(owner);
    }

    @Override
    public void updateLog() {
        if (this.mlogFactory == null) {
            return;
        }
        this.mlogFactory.update();
    }

    @Override
    public void setMLogFactory(MLogFactory mlogFactory) {
        this.mlogFactory = mlogFactory;
    }
}

