/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.matcher;

import de.mhus.lib.core.matcher.ModelPart;
import de.mhus.lib.core.matcher.ModelPattern;
import de.mhus.lib.errors.MRuntimeException;
import java.util.Map;

public class ModelVariable
extends ModelPattern {
    private String name;

    @Override
    public void setPattern(String pattern) {
        if (pattern.startsWith("${") && pattern.endsWith("}")) {
            pattern = pattern.substring(2, pattern.length() - 1);
        }
        this.name = pattern;
    }

    @Override
    protected boolean matches(ModelPart model, Map<String, ?> map, String str) {
        if (map == null) {
            throw new MRuntimeException(new Object[]{"variables not available, use condition not matcher"});
        }
        Object val = map.get(this.name);
        if (val == null) {
            return false;
        }
        int c = str.compareTo(val.toString());
        switch (this.getCondition()) {
            case EQ: {
                return c == 0;
            }
            case GE: {
                return c >= 0;
            }
            case GR: {
                return c > 0;
            }
            case LE: {
                return c <= 0;
            }
            case LT: {
                return c < 0;
            }
        }
        return false;
    }

    @Override
    public String getPattern() {
        return this.name;
    }

    @Override
    public String getPatternStr() {
        return "${" + this.name + "}";
    }

    @Override
    public String getPatternTypeName() {
        return "var";
    }
}

