/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.matcher;

import de.mhus.lib.core.matcher.ModelPart;
import de.mhus.lib.core.matcher.ModelPattern;
import de.mhus.lib.errors.MRuntimeException;
import java.math.BigDecimal;
import java.util.Map;

public class ModelNumber
extends ModelPattern {
    private BigDecimal right;
    private String name;

    @Override
    public void setPattern(String pattern) {
        if (pattern.startsWith("${") && pattern.endsWith("}")) {
            this.name = pattern.substring(2, pattern.length() - 1);
        } else {
            this.right = new BigDecimal(pattern);
        }
    }

    @Override
    protected boolean matches(ModelPart model, Map<String, ?> map, String str) {
        if (this.name != null) {
            if (map == null) {
                throw new MRuntimeException(new Object[]{"variables not available, use condition not matcher"});
            }
            Object val = map.get(this.name);
            if (val == null) {
                return false;
            }
            str = val.toString();
        }
        BigDecimal left = new BigDecimal(str);
        int c = left.compareTo(this.right);
        switch (this.getCondition()) {
            case EQ: {
                return c == 0;
            }
            case GE: {
                return c >= 0;
            }
            case GR: {
                return c > 0;
            }
            case LE: {
                return c <= 0;
            }
            case LT: {
                return c < 0;
            }
        }
        return false;
    }

    @Override
    public String getPattern() {
        if (this.name != null) {
            return "${" + this.name + "}";
        }
        return this.right.toString();
    }

    @Override
    public String getPatternStr() {
        return this.getPattern();
    }

    @Override
    public String getPatternTypeName() {
        return "number";
    }
}

