/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.crypt.pem;

import de.mhus.lib.core.crypt.pem.PemBlock;
import de.mhus.lib.core.crypt.pem.PemUtil;
import java.security.PublicKey;

public class SecurityPublicKey
implements PublicKey {
    private static final long serialVersionUID = 1L;
    private String algorithm;
    private String format;
    private byte[] encoded;

    public SecurityPublicKey(PemBlock pem) {
        if (!PemUtil.isPubKey(pem)) {
            throw new SecurityException("Block is not a public key: " + pem.getName());
        }
        this.algorithm = pem.getString("Method", "");
        this.format = pem.getString("Format", "");
        this.encoded = pem.getBytesBlock();
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public String getFormat() {
        return this.format;
    }

    @Override
    public byte[] getEncoded() {
        return this.encoded;
    }
}

