/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.crypt;

import de.mhus.lib.core.MMath;
import de.mhus.lib.core.crypt.MRandom;
import java.io.IOException;
import java.io.OutputStream;

public class SaltOutputStream
extends OutputStream {
    private OutputStream next;
    private MRandom random;
    private int cnt;
    private boolean addRandomBlocks;
    private byte salt;
    private int maxBlockSize;

    public SaltOutputStream(OutputStream next, MRandom random, int maxBlockSize, boolean addRandomBlocks) {
        this.next = next;
        this.random = random;
        this.addRandomBlocks = addRandomBlocks;
        this.maxBlockSize = maxBlockSize;
        this.cnt = 0;
    }

    @Override
    public void write(int b) throws IOException {
        --this.cnt;
        if (this.cnt <= 0) {
            if (this.addRandomBlocks) {
                this.cnt = MMath.unsignetByteToInt(this.random.getByte()) % this.maxBlockSize;
                this.next.write(this.cnt);
                for (int i = 0; i < this.cnt; ++i) {
                    this.next.write(this.random.getByte());
                }
            }
            this.salt = this.random.getByte();
            this.cnt = MMath.unsignetByteToInt(this.random.getByte()) % this.maxBlockSize;
            this.next.write(this.salt);
            this.next.write(this.cnt);
        }
        b = MMath.addRotate((byte)b, this.salt);
        this.next.write(b);
    }

    @Override
    public void close() throws IOException {
        this.next.close();
    }

    @Override
    public void flush() throws IOException {
        this.next.flush();
    }
}

