/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.crypt;

import de.mhus.lib.core.MFile;
import de.mhus.lib.core.MString;
import de.mhus.lib.core.crypt.MBouncy;
import de.mhus.lib.core.crypt.MCrypt;
import de.mhus.lib.core.util.SecureString;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.security.KeyPair;
import java.security.PrivateKey;

public class CryptedString
extends SecureString
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private static final int AES_SIZE = 16;
    private byte[] rand;
    private String pubKeyMd5;

    public CryptedString() {
    }

    public CryptedString(KeyPair key, String secret) {
        try {
            if (secret == null) {
                this.data = null;
                this.length = 0;
            } else {
                this.length = secret.length();
                byte[] r = MBouncy.createRandom(16);
                this.rand = MBouncy.encryptRsa117(r, key.getPublic());
                this.data = secret.getBytes("UTF-8");
                this.data = MBouncy.encryptAes(r, this.data);
            }
            this.pubKeyMd5 = MCrypt.md5(MBouncy.getPublicKey(key));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public CryptedString(String pubKey, String secret) {
        try {
            if (secret == null) {
                this.data = null;
                this.length = 0;
            } else {
                this.length = secret.length();
                byte[] r = MBouncy.createRandom(16);
                this.rand = MBouncy.encryptRsa117(r, MBouncy.getPublicKey(pubKey));
                this.data = secret.getBytes("UTF-8");
                this.data = MBouncy.encryptAes(r, this.data);
            }
            this.pubKeyMd5 = MCrypt.md5(pubKey);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String value(KeyPair key) {
        if (this.data == null) {
            return null;
        }
        try {
            byte[] r = MBouncy.decryptRsa117(this.rand, key.getPrivate());
            byte[] d = MBouncy.decryptAes(r, this.data);
            return new String(d, "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String value(String privKey) {
        if (this.data == null) {
            return null;
        }
        try {
            PrivateKey key = MBouncy.getPrivateKey(privKey);
            byte[] r = MBouncy.decryptRsa117(this.rand, key);
            byte[] d = MBouncy.decryptAes(r, this.data);
            return new String(d, "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getPublicKeyMd5() {
        return this.pubKeyMd5;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.length);
        if (this.data == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(this.data.length);
            out.write(this.data);
            out.writeInt(this.rand.length);
            out.write(this.rand);
            out.writeObject(this.pubKeyMd5);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.length = in.readInt();
        int len = in.readInt();
        if (len < 0) {
            this.data = null;
            this.rand = null;
        } else {
            this.data = new byte[len];
            MFile.readBinary(in, this.data, 0, len);
            int l = in.readInt();
            this.rand = new byte[l];
            MFile.readBinary(in, this.rand, 0, l);
            this.pubKeyMd5 = (String)in.readObject();
        }
    }

    @Override
    public String value() {
        return (this.rand == null ? "?" : MBouncy.encodeBase64(this.rand)) + "!" + (this.data == null ? "?" : MBouncy.encodeBase64(this.data));
    }

    public static SecureString create(String pubKey, String secret) {
        if (MString.isSet(pubKey)) {
            return new CryptedString(pubKey, secret);
        }
        return new SecureString(secret);
    }

    public static String value(SecureString string, KeyPair key) {
        if (string == null) {
            return null;
        }
        if (!(string instanceof CryptedString)) {
            return string.value();
        }
        return ((CryptedString)string).value(key);
    }
}

